/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.report;

import java.util.ArrayList;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class DocumentFormatter {
    private KnowledgeBaseManager kbm;

    public DocumentFormatter(KnowledgeBaseManager kbm) {
        this.kbm = kbm;
    }

    public String format(Integer idDocument) throws KnowledgeBaseException {
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        Document document = documentDAO.getDocument(idDocument);
        ArrayList<Author> authors = documentDAO.getAuthors(document.getDocumentID());
        Journal journal = documentDAO.getJournal(document.getDocumentID());
        PublishDate publishDate = documentDAO.getPublishDate(document.getDocumentID());
        String result = "";
        for (int authorIndex = 0; authorIndex < authors.size(); ++authorIndex) {
            result = result + authors.get(authorIndex).getAuthorName() + ", ";
        }
        result = result + document.getTitle() + ". ";
        result = result + journal.getSource() + " " + document.getVolume() + ":" + document.getIssue() + " ";
        result = result + "(" + publishDate.getYear() + ") ";
        result = result + document.getBeginPage() + "-" + document.getEndPage() + ". ";
        result = result + "Times cited: " + document.getCitationsCount();
        return result;
    }
}

