/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.preprocessing.reduction.data;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.preprocessing.reduction.data.DataFilter;

public class FilterItemByFrequency
implements DataFilter {
    private int minFrequency;

    public FilterItemByFrequency(int minFrequency) {
        this.minFrequency = minFrequency;
    }

    public void execute(Dataset dataset) {
        ArrayList<Integer> itemsList = dataset.getItems();
        for (int i = 0; i < itemsList.size(); ++i) {
            Integer itemID = itemsList.get(i);
            try {
                if (dataset.getItemFrequency(itemID) >= this.minFrequency) continue;
                dataset.removeItem(itemID);
                continue;
            }
            catch (NotExistsItemException e) {
                System.err.println("An internal error occur within the dataset. The item " + itemID + " does not exist.");
                e.printStackTrace(System.err);
            }
        }
    }
}

