/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.preprocessing.reduction.data;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.preprocessing.reduction.data.DataFilter;

public class FilterDocumentsByItemsCount
implements DataFilter {
    private int minItemsInDocument;

    public FilterDocumentsByItemsCount(int minItemsInDocument) {
        this.minItemsInDocument = minItemsInDocument;
    }

    public void execute(Dataset dataset) {
        ArrayList<Integer> docList = dataset.getDocuments();
        for (int i = 0; i < docList.size(); ++i) {
            Integer docID = docList.get(i);
            try {
                if (dataset.getItemsInDocumentCount(docID) >= this.minItemsInDocument) continue;
                dataset.removeDocument(docID);
                continue;
            }
            catch (NotExistsItemException e) {
                System.err.println("An internal error occur within the dataset. The document " + docID + " does not exist.");
                e.printStackTrace(System.err);
            }
        }
    }
}

