/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.preprocessing.reduction.data;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.preprocessing.reduction.data.DataFilter;

public class FilterDocumentsByCitations
implements DataFilter {
    private int minCitations;

    public FilterDocumentsByCitations(int minCitations) {
        this.minCitations = minCitations;
    }

    public void execute(Dataset dataset) {
        ArrayList<Integer> docList = dataset.getDocuments();
        for (int i = 0; i < docList.size(); ++i) {
            Integer docID = docList.get(i);
            try {
                if (dataset.getDocumentCitations(docID) >= this.minCitations) continue;
                dataset.removeDocument(docID);
                continue;
            }
            catch (NotExistsItemException e) {
                System.err.println("An internal error occur within the dataset. The document " + docID + " does not exist.");
                e.printStackTrace(System.err);
            }
        }
    }
}

