/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.mapping.clustering.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.dataset.NetworkPair;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.mapping.Node;
import scimat.api.mapping.WholeNetwork;
import scimat.api.mapping.clustering.result.Cluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterSet
implements Serializable {
    private WholeNetwork wholeNetwork;
    private ArrayList<Cluster> clusterList;
    private TreeMap<Integer, Integer> clusterOfNodes;

    public ClusterSet(UndirectNetworkMatrix network) {
        this.wholeNetwork = new WholeNetwork(network);
        this.clusterList = new ArrayList();
        this.clusterOfNodes = new TreeMap();
    }

    public WholeNetwork getWholeNetwork() {
        return this.wholeNetwork;
    }

    public int getClustersCount() {
        return this.clusterList.size();
    }

    public ArrayList<Cluster> getClusters() {
        return new ArrayList<Cluster>(this.clusterList);
    }

    public Cluster getCluster(int cluster) {
        return this.clusterList.get(cluster);
    }

    public boolean addCluster(ArrayList<Integer> nodes) {
        int i;
        for (i = 0; i < nodes.size(); ++i) {
            Node node = this.wholeNetwork.getNode(nodes.get(i));
            if (node != null && this.getClusterOfNode(node.getNodeID()) == -1) continue;
            return false;
        }
        Cluster cluter = new Cluster(nodes);
        this.clusterList.add(cluter);
        int clusterPosition = this.clusterList.size() - 1;
        for (i = 0; i < nodes.size(); ++i) {
            this.addClusterToNode(nodes.get(i), clusterPosition);
        }
        return true;
    }

    public boolean addCluster(ArrayList<Integer> nodes, Integer mainNode) {
        int i;
        boolean containMainNode = false;
        for (i = 0; i < nodes.size(); ++i) {
            Node node = this.wholeNetwork.getNode(nodes.get(i));
            if (node == null || this.getClusterOfNode(node.getNodeID()) != -1) {
                return false;
            }
            if (node.getNodeID().intValue() != mainNode.intValue()) continue;
            containMainNode = true;
        }
        if (containMainNode) {
            Cluster cluter = new Cluster(nodes, mainNode);
            this.clusterList.add(cluter);
            int clusterPosition = this.clusterList.size() - 1;
            for (i = 0; i < nodes.size(); ++i) {
                this.addClusterToNode(nodes.get(i), clusterPosition);
            }
            return true;
        }
        return false;
    }

    public int getClusterOfNode(int node) {
        Integer cluster = this.clusterOfNodes.get(node);
        if (cluster != null) {
            return cluster;
        }
        return -1;
    }

    public ArrayList<NetworkPair> getClusterInternalPairs(int cluster) {
        return this.wholeNetwork.getInternalPairs(this.clusterList.get(cluster).getNodes());
    }

    public ArrayList<NetworkPair> getClusterExternalPairs(int cluster) {
        return this.wholeNetwork.getExternalPairs(this.clusterList.get(cluster).getNodes());
    }

    public ArrayList<NetworkPair> getIntraClusterPairs(int cluster1, int cluster2) {
        return this.wholeNetwork.getIntraNodesPairs(this.getCluster(cluster1).getNodes(), this.getCluster(cluster2).getNodes());
    }

    private void addClusterToNode(Integer nodeID, int cluster) {
        this.clusterOfNodes.put(nodeID, cluster);
    }
}

