/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.mapping.clustering;

import java.util.ArrayList;
import java.util.Collection;
import scimat.api.analysis.network.statistics.MaxAverageSimilarNode;
import scimat.api.dataset.NetworkPair;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.mapping.clustering.ClusteringAlgorithm;
import scimat.api.mapping.clustering.result.ClusterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumLinkClustering
implements ClusteringAlgorithm {
    private int minNetworkSize;
    private int maxNetworkSize;
    private double cutOff;

    public SumLinkClustering(int minNetworkSize, int maxNetworkSize, double cutOff) {
        this.minNetworkSize = minNetworkSize;
        this.maxNetworkSize = maxNetworkSize;
        this.cutOff = cutOff;
    }

    @Override
    public ClusterSet execute(UndirectNetworkMatrix network) {
        int i;
        ClusterSet clusterSet = new ClusterSet(network);
        ArrayList<ArrayList<Integer>> clusters = this.eachNodeToCluster(network.getNodes());
        boolean joinedClusters = true;
        while (joinedClusters) {
            double maxSum = 0.0;
            int clusterToJoinI = -1;
            int clusterToJoinJ = -1;
            for (i = 0; i < clusters.size(); ++i) {
                ArrayList<Integer> clusterI = clusters.get(i);
                for (int j = i + 1; j < clusters.size(); ++j) {
                    double sumSimilarity;
                    ArrayList<Integer> clusterJ = clusters.get(j);
                    ArrayList<NetworkPair> pairs = network.getIntraNodesPairs(clusterI, clusterJ);
                    if (pairs.size() <= 0 || !((sumSimilarity = this.getSumPairsValue(pairs)) > maxSum) || !(sumSimilarity >= this.cutOff)) continue;
                    maxSum = sumSimilarity;
                    clusterToJoinI = i;
                    clusterToJoinJ = j;
                }
            }
            if (clusterToJoinI != -1) {
                joinedClusters = this.joinClusters(clusters, clusterToJoinI, clusterToJoinJ);
                continue;
            }
            joinedClusters = false;
        }
        for (i = 0; i < clusters.size(); ++i) {
            if (clusters.get(i).size() < this.minNetworkSize) continue;
            clusterSet.addCluster(clusters.get(i), new MaxAverageSimilarNode().execute(network, clusters.get(i)));
        }
        return clusterSet;
    }

    private ArrayList<ArrayList<Integer>> eachNodeToCluster(ArrayList<Integer> nodes) {
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < nodes.size(); ++i) {
            ArrayList<Integer> cluster = new ArrayList<Integer>();
            cluster.add(nodes.get(i));
            clusters.add(cluster);
        }
        return clusters;
    }

    private boolean joinClusters(ArrayList<ArrayList<Integer>> clusters, int i, int j) {
        boolean flag;
        if (clusters.get(i).size() + clusters.get(j).size() <= this.maxNetworkSize) {
            clusters.get(i).addAll((Collection<Integer>)clusters.get(j));
            clusters.remove(j);
            flag = true;
        } else {
            flag = false;
        }
        return flag;
    }

    private double getSumPairsValue(ArrayList<NetworkPair> pairs) {
        double sum = 0.0;
        if (pairs.size() > 0) {
            for (int i = 0; i < pairs.size(); ++i) {
                sum += pairs.get(i).getValue();
            }
        }
        return sum;
    }
}

