/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.mapping.clustering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import scimat.api.dataset.NetworkPair;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.mapping.clustering.ClusteringAlgorithm;
import scimat.api.mapping.clustering.result.ClusterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentersSimpleGroupingAlgorithm
implements ClusteringAlgorithm {
    private int minNetworkSize;
    private int maxNetworkSize;

    public CentersSimpleGroupingAlgorithm(int minNetworkSize, int maxNetworkSize) {
        this.minNetworkSize = minNetworkSize;
        this.maxNetworkSize = maxNetworkSize;
    }

    @Override
    public ClusterSet execute(UndirectNetworkMatrix network) {
        TreeMap<Integer, Integer> vNodesCounter = new TreeMap<Integer, Integer>();
        int currentMaxNetworkSize = this.maxNetworkSize - 1;
        ClusterSet result = new ClusterSet(network);
        ArrayList<NetworkPair> pairList = network.getNetworkPairs();
        Collections.sort(pairList, new Comparator<NetworkPair>(){

            @Override
            public int compare(NetworkPair o1, NetworkPair o2) {
                return Double.compare(o2.getValue(), o1.getValue());
            }
        });
        int i = 0;
        while (i < pairList.size()) {
            boolean themeFound = false;
            NetworkPair pair = pairList.get(i);
            this.incrementNodesCounter(pair.getID().getElementA(), vNodesCounter);
            this.incrementNodesCounter(pair.getID().getElementB(), vNodesCounter);
            if (vNodesCounter.get(pair.getID().getElementA()) == currentMaxNetworkSize) {
                result.addCluster(this.extractThemeNodes(pairList, i, pair.getID().getElementA(), currentMaxNetworkSize), pair.getID().getElementA());
                themeFound = true;
            } else if (vNodesCounter.get(pair.getID().getElementB()) == currentMaxNetworkSize) {
                result.addCluster(this.extractThemeNodes(pairList, i, pair.getID().getElementB(), currentMaxNetworkSize), pair.getID().getElementB());
                themeFound = true;
            }
            if (themeFound) {
                vNodesCounter.clear();
                i = 0;
                continue;
            }
            if (++i != pairList.size() || currentMaxNetworkSize <= this.minNetworkSize - 1) continue;
            vNodesCounter.clear();
            i = 0;
            --currentMaxNetworkSize;
        }
        return result;
    }

    private void incrementNodesCounter(Integer id, TreeMap<Integer, Integer> vNodesCounter) {
        if (vNodesCounter.containsKey(id)) {
            vNodesCounter.put(id, vNodesCounter.get(id) + 1);
        } else {
            vNodesCounter.put(id, 1);
        }
    }

    private ArrayList<Integer> extractThemeNodes(ArrayList<NetworkPair> pairList, int highestPairPosition, Integer mainNodeIndex, int currentMaxNetworkSize) {
        ArrayList<Integer> themeNodes = new ArrayList<Integer>();
        int i = highestPairPosition;
        int nAddedPairs = 0;
        themeNodes.add(mainNodeIndex);
        while (nAddedPairs < currentMaxNetworkSize) {
            if (pairList.get(i).getID().getElementA().intValue() == mainNodeIndex.intValue()) {
                themeNodes.add(pairList.get(i).getID().getElementB());
                ++nAddedPairs;
            } else if (pairList.get(i).getID().getElementB().intValue() == mainNodeIndex.intValue()) {
                themeNodes.add(pairList.get(i).getID().getElementA());
                ++nAddedPairs;
            }
            --i;
        }
        this.removeUsedPair(pairList, themeNodes);
        return themeNodes;
    }

    private void removeUsedPair(ArrayList<NetworkPair> pairList, ArrayList<Integer> themeNodes) {
        for (int i = 0; i < themeNodes.size(); ++i) {
            for (int j = 0; j < pairList.size(); ++j) {
                NetworkPair pair = pairList.get(j);
                if (pair.getID().getElementA().intValue() != themeNodes.get(i).intValue() && pair.getID().getElementB().intValue() != themeNodes.get(i).intValue()) continue;
                pairList.remove(j);
                --j;
            }
        }
    }
}

