/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.dataset.NetworkPair;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.mapping.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WholeNetwork
implements Serializable {
    private UndirectNetworkMatrix network;
    private TreeMap<Integer, Node> nodeList;

    public WholeNetwork(UndirectNetworkMatrix network) {
        this.network = network;
        this.nodeList = new TreeMap();
        ArrayList<Integer> nodes = this.network.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Integer nodeID = nodes.get(i);
            this.nodeList.put(nodeID, new Node(nodeID));
        }
    }

    public Node getNode(Integer nodeID) {
        return this.nodeList.get(nodeID);
    }

    public ArrayList<Node> getNodes() {
        return new ArrayList<Node>(this.nodeList.values());
    }

    public ArrayList<Integer> getNodesID() {
        return new ArrayList<Integer>(this.nodeList.keySet());
    }

    public boolean containsNode(Integer nodeID) {
        return this.nodeList.containsKey(nodeID);
    }

    public boolean containsEdge(Integer nodeA, Integer nodeB) {
        return this.network.containsEdge(nodeA, nodeB);
    }

    public int getNodesCount() {
        return this.network.getNodesCount();
    }

    public double getEdge(Integer nodeSource, Integer nodeTarget) throws NotExistsItemException {
        return this.network.getEdge(nodeSource, nodeTarget);
    }

    public ArrayList<NetworkPair> getNetworkPairs() {
        return this.network.getNetworkPairs();
    }

    public ArrayList<NetworkPair> getInternalPairs(ArrayList<Integer> nodesList) {
        return this.network.getInternalPairs(nodesList);
    }

    public ArrayList<NetworkPair> getExternalPairs(ArrayList<Integer> nodesList) {
        return this.network.getExternalPairs(nodesList);
    }

    public ArrayList<NetworkPair> getIntraNodesPairs(ArrayList<Integer> nodesSource, ArrayList<Integer> nodesTarget) {
        return this.network.getIntraNodesPairs(nodesSource, nodesTarget);
    }
}

