/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.loader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.loader.GenericLoader;
import scimat.api.loader.LoaderException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.SubjectCategoryDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RISLoader
implements GenericLoader {
    private String file;
    private boolean importReferences;

    public RISLoader(String file, boolean importReferences) {
        this.file = file;
        this.importReferences = importReferences;
    }

    @Override
    public void execute(KnowledgeBaseManager kbm) throws LoaderException, KnowledgeBaseException {
        ArrayList<TreeMap<String, String>> records = this.loadRecords();
        try {
            this.addRecordToKnowledgeBase(records, kbm);
            kbm.commit();
            CurrentProject.getInstance().getKbObserver().fireKnowledgeBaseRefresh();
        }
        catch (KnowledgeBaseException e) {
            try {
                kbm.getConnection().rollback();
            }
            catch (SQLException s) {
                throw new KnowledgeBaseException(s);
            }
            kbm.close();
            throw e;
        }
    }

    private ArrayList<TreeMap<String, String>> loadRecords() throws LoaderException {
        BufferedReader input = null;
        ArrayList<TreeMap<String, String>> records = new ArrayList<TreeMap<String, String>>();
        try {
            String line;
            input = new BufferedReader(new FileReader(this.file));
            TreeMap<String, String> record = new TreeMap<String, String>();
            String field = "";
            String fieldKey = null;
            while ((line = input.readLine()) != null) {
                String tmpField;
                if (line.matches("\\w{2}  - .*")) {
                    int position;
                    fieldKey = line.substring(0, 2);
                    field = line.substring(6);
                    if (fieldKey.equals("ER")) {
                        records.add(record);
                        record = new TreeMap();
                        continue;
                    }
                    if (fieldKey.startsWith("N1") && (position = field.indexOf(":")) >= 0) {
                        fieldKey = field.substring(0, position);
                        field = field.substring(position + 2);
                    }
                    tmpField = (tmpField = (String)record.get(fieldKey)) != null ? tmpField + "\n" + field : field;
                    record.put(fieldKey, tmpField);
                    continue;
                }
                if (fieldKey == null) continue;
                tmpField = (String)record.get(fieldKey);
                tmpField = tmpField != null ? tmpField + "\n" + line : line;
                record.put(fieldKey, tmpField);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new LoaderException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            throw new LoaderException(ioe.getMessage(), ioe);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    throw new LoaderException(ioe.getMessage(), ioe);
                }
            }
        }
        return records;
    }

    private void addRecordToKnowledgeBase(ArrayList<TreeMap<String, String>> records, KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        AffiliationDAO affiliationDAO = new AffiliationDAO(kbm);
        AuthorDAO authorDAO = new AuthorDAO(kbm);
        AuthorReferenceDAO authorReferenceDAO = new AuthorReferenceDAO(kbm);
        AuthorReferenceReferenceDAO authorReferenceReferenceDAO = new AuthorReferenceReferenceDAO(kbm);
        DocumentAffiliationDAO documentAffiliationDAO = new DocumentAffiliationDAO(kbm);
        DocumentAuthorDAO documentAuthorDAO = new DocumentAuthorDAO(kbm);
        DocumentDAO documentDAO = new DocumentDAO(kbm);
        DocumentReferenceDAO documentReferenceDAO = new DocumentReferenceDAO(kbm);
        DocumentWordDAO documentWordDAO = new DocumentWordDAO(kbm);
        JournalDAO journalDAO = new JournalDAO(kbm);
        JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = new JournalSubjectCategoryPublishDateDAO(kbm);
        PublishDateDAO publishDateDAO = new PublishDateDAO(kbm);
        ReferenceDAO referenceDAO = new ReferenceDAO(kbm);
        ReferenceSourceDAO referenceSourceDAO = new ReferenceSourceDAO(kbm);
        SubjectCategoryDAO subjectCategoryDAO = new SubjectCategoryDAO(kbm);
        WordDAO wordDAO = new WordDAO(kbm);
        for (int i = 0; i < records.size(); ++i) {
            System.out.println("Record " + (i + 1));
            TreeMap<String, String> record = records.get(i);
            Integer documentID = this.addDocument(record, documentDAO);
            this.addAuthor(documentID, record, authorDAO, documentAuthorDAO);
            this.addAffiliation(documentID, record, affiliationDAO, documentAffiliationDAO);
            Integer journalID = this.addJournal(documentID, record, journalDAO, documentDAO);
            Integer publishDateID = this.addPublishDate(documentID, record, publishDateDAO, documentDAO);
            if (this.importReferences) {
                this.addReference(documentID, record, referenceDAO, documentReferenceDAO, authorReferenceDAO, referenceSourceDAO, authorReferenceReferenceDAO);
            }
            this.addWord(documentID, record, wordDAO, documentWordDAO);
        }
    }

    private Integer addDocument(TreeMap<String, String> record, DocumentDAO documentDAO) throws KnowledgeBaseException {
        String title = record.get("T1");
        String docAbstract = record.get("AB");
        String type = record.get("TY");
        String doi = record.get("doi");
        String sourceIdentifier = record.get("UR");
        String volume = record.get("VL");
        String issue = record.get("IS");
        String beginPage = record.get("SP");
        String endPage = record.get("EP");
        String citationString = record.get("Cited By (since 1996)");
        int citations = 0;
        if (citationString != null) {
            try {
                citations = Integer.valueOf(citationString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return documentDAO.addDocument(title, docAbstract, type, citations, doi, sourceIdentifier, volume, issue, beginPage, endPage, false);
    }

    private void addAuthor(Integer documentID, TreeMap<String, String> record, AuthorDAO authorDAO, DocumentAuthorDAO documentAuthorDAO) throws KnowledgeBaseException {
        String authorNames = record.get("AU");
        if (authorNames != null) {
            String[] splitAuthorName = authorNames.split("\n");
            for (int i = 0; i < splitAuthorName.length; ++i) {
                String authorName = splitAuthorName != null ? splitAuthorName[i] : splitAuthorName[i];
                Author author = authorDAO.getAuthor(authorName, "");
                Integer authorID = author == null ? authorDAO.addAuthor(authorName, "", false) : author.getAuthorID();
                if (documentAuthorDAO.checkDocumentAuthor(documentID, authorID)) continue;
                documentAuthorDAO.addDocumentAuthor(documentID, authorID, i + 1, false);
            }
        }
    }

    private void addAffiliation(Integer documentID, TreeMap<String, String> record, AffiliationDAO affiliationDAO, DocumentAffiliationDAO documentAffiliationDAO) throws KnowledgeBaseException {
        String fullAffiliations = record.get("AD");
        if (fullAffiliations != null) {
            String[] splitFullAffiliation = fullAffiliations.split("\n");
            for (int i = 0; i < splitFullAffiliation.length; ++i) {
                String fullAffiliation = splitFullAffiliation[i];
                Affiliation affiliation = affiliationDAO.getAffiliation(fullAffiliation);
                Integer affiliationID = affiliation == null ? affiliationDAO.addAffiliation(fullAffiliation, false) : affiliation.getAffiliationID();
                if (documentAffiliationDAO.checkDocumentAffiliation(documentID, affiliationID)) continue;
                documentAffiliationDAO.addDocumentAffiliation(documentID, affiliationID, false);
            }
        }
    }

    private Integer addJournal(Integer documentID, TreeMap<String, String> record, JournalDAO journalDAO, DocumentDAO documentDAO) throws KnowledgeBaseException {
        Integer journalID = null;
        String source = record.get("JF");
        if (source != null) {
            Journal journal = journalDAO.getJournal(source);
            journalID = journal == null ? journalDAO.addJournal(source, "", false) : journal.getJournalID();
            documentDAO.setJournal(documentID, journalID, false);
        }
        return journalID;
    }

    private Integer addPublishDate(Integer documentID, TreeMap<String, String> record, PublishDateDAO publishDateDAO, DocumentDAO documentDAO) throws KnowledgeBaseException {
        Integer publishDateID = null;
        String date = record.get("PY");
        if (date != null) {
            String year = date.substring(0, 4);
            PublishDate publishDate = publishDateDAO.getPublishDate(year, date);
            publishDateID = publishDate == null ? publishDateDAO.addPublishDate(year, date, false) : publishDate.getPublishDateID();
            documentDAO.setPublishDate(documentID, publishDateID, false);
        }
        return publishDateID;
    }

    private void addReference(Integer documentID, TreeMap<String, String> record, ReferenceDAO referenceDAO, DocumentReferenceDAO documentReferenceDAO, AuthorReferenceDAO authorReferenceDAO, ReferenceSourceDAO referenceSourceDAO, AuthorReferenceReferenceDAO authorReferenceReferenceDAO) throws KnowledgeBaseException {
        String field = record.get("References");
        if (field != null) {
            String[] splitField = record.get("References").split(";");
            for (int i = 0; i < splitField.length; ++i) {
                String fullReference = splitField[i].trim();
                Reference reference = referenceDAO.getReference(fullReference);
                Integer referenceID = reference == null ? referenceDAO.addReference(fullReference, "", "", "", "", "", "RIS", false) : reference.getReferenceID();
                if (documentReferenceDAO.checkDocumentReference(documentID, referenceID)) continue;
                documentReferenceDAO.addDocumentReference(documentID, referenceID, false);
            }
        }
    }

    private void addWord(Integer documentID, TreeMap<String, String> record, WordDAO wordDAO, DocumentWordDAO documentWordDAO) throws KnowledgeBaseException {
        String wordNames = null;
        if (record.containsKey("KW")) {
            wordNames = record.get("KW");
        }
        if (wordNames != null) {
            String[] splitWordName = wordNames.replaceAll(" +", "-").toUpperCase().split("\n");
            for (int i = 0; i < splitWordName.length; ++i) {
                String wordName = splitWordName[i].trim();
                Word word = wordDAO.getWord(wordName);
                Integer wordID = word == null ? wordDAO.addWord(wordName, false) : word.getWordID();
                DocumentWord documentWord = documentWordDAO.getDocumentWord(documentID, wordID);
                if (documentWord != null) continue;
                documentWordDAO.addDocumentWord(documentID, wordID, true, false, false, false);
            }
        }
    }

    private void showRecord(ArrayList<TreeMap<String, String>> records) {
        for (int i = 0; i < records.size(); ++i) {
            TreeMap<String, String> record = records.get(i);
            System.out.println("Record " + i);
            for (String key : record.keySet()) {
                System.out.println("  " + key + " -> " + record.get(key));
            }
        }
    }
}

