/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.loader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.loader.GenericLoader;
import scimat.api.loader.LoaderException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.SubjectCategoryDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.SubjectCategory;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISIWoSLoader
implements GenericLoader {
    private String file;
    private boolean importReferences;

    public ISIWoSLoader(String file, boolean importReferences) {
        this.file = file;
        this.importReferences = importReferences;
    }

    @Override
    public void execute(KnowledgeBaseManager kbm) throws LoaderException, KnowledgeBaseException {
        ArrayList<TreeMap<String, String>> records = this.loadRecords();
        try {
            this.addRecordToKnowledgeBase(records, kbm);
            kbm.commit();
            CurrentProject.getInstance().getKbObserver().fireKnowledgeBaseRefresh();
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                kbm.getConnection().rollback();
            }
            catch (SQLException s) {
                s.printStackTrace(System.err);
                throw new KnowledgeBaseException(s);
            }
            throw e;
        }
    }

    private ArrayList<TreeMap<String, String>> loadRecords() throws LoaderException {
        BufferedReader input = null;
        ArrayList<TreeMap<String, String>> records = new ArrayList<TreeMap<String, String>>();
        try {
            input = new BufferedReader(new FileReader(this.file));
            String line = input.readLine();
            line = input.readLine();
            TreeMap<String, String> record = new TreeMap<String, String>();
            String field = "";
            String fieldKeyToAdd = "";
            while ((line = input.readLine()) != null) {
                if (line.length() <= 1) continue;
                String currentFieldKey = line.substring(0, 2);
                if (currentFieldKey.equals("ER")) {
                    record.put(fieldKeyToAdd, field);
                    records.add(record);
                    record = new TreeMap();
                    fieldKeyToAdd = "";
                    continue;
                }
                if (currentFieldKey.equals("  ")) {
                    field = field + "\n" + line.substring(3);
                    continue;
                }
                if (currentFieldKey.equals("EF")) continue;
                if (!fieldKeyToAdd.isEmpty()) {
                    record.put(fieldKeyToAdd, field);
                }
                fieldKeyToAdd = currentFieldKey;
                field = line.substring(3);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new LoaderException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            throw new LoaderException(ioe.getMessage(), ioe);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    throw new LoaderException(ioe.getMessage(), ioe);
                }
            }
        }
        return records;
    }

    private void addRecordToKnowledgeBase(ArrayList<TreeMap<String, String>> records, KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        AffiliationDAO affiliationDAO = new AffiliationDAO(kbm);
        AuthorDAO authorDAO = new AuthorDAO(kbm);
        AuthorReferenceDAO authorReferenceDAO = new AuthorReferenceDAO(kbm);
        AuthorReferenceReferenceDAO authorReferenceReferenceDAO = new AuthorReferenceReferenceDAO(kbm);
        DocumentAffiliationDAO documentAffiliationDAO = new DocumentAffiliationDAO(kbm);
        DocumentAuthorDAO documentAuthorDAO = new DocumentAuthorDAO(kbm);
        DocumentDAO documentDAO = new DocumentDAO(kbm);
        DocumentReferenceDAO documentReferenceDAO = new DocumentReferenceDAO(kbm);
        DocumentWordDAO documentWordDAO = new DocumentWordDAO(kbm);
        JournalDAO journalDAO = new JournalDAO(kbm);
        JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = new JournalSubjectCategoryPublishDateDAO(kbm);
        PublishDateDAO publishDateDAO = new PublishDateDAO(kbm);
        ReferenceDAO referenceDAO = new ReferenceDAO(kbm);
        ReferenceSourceDAO referenceSourceDAO = new ReferenceSourceDAO(kbm);
        SubjectCategoryDAO subjectCategoryDAO = new SubjectCategoryDAO(kbm);
        WordDAO wordDAO = new WordDAO(kbm);
        for (int i = 0; i < records.size(); ++i) {
            TreeMap<String, String> record = records.get(i);
            Integer documentID = this.addDocument(record, documentDAO);
            this.addAuthor(documentID, record, authorDAO, documentAuthorDAO);
            this.addAffiliation(documentID, record, affiliationDAO, documentAffiliationDAO);
            Integer journalID = this.addJournal(documentID, record, journalDAO, documentDAO);
            Integer publishDateID = this.addPublishDate(documentID, record, publishDateDAO, documentDAO);
            if (this.importReferences) {
                this.addReference(documentID, record, referenceDAO, documentReferenceDAO, authorReferenceDAO, referenceSourceDAO, authorReferenceReferenceDAO);
            }
            this.addSubjectCategory(journalID, publishDateID, record, subjectCategoryDAO, journalSubjectCategoryPublishDateDAO);
            this.addWord(true, documentID, record, wordDAO, documentWordDAO);
            this.addWord(false, documentID, record, wordDAO, documentWordDAO);
        }
    }

    private Integer addDocument(TreeMap<String, String> record, DocumentDAO documentDAO) throws KnowledgeBaseException {
        String title = record.get("TI").replaceAll("\n", " ");
        String docAbstract = record.get("AB") != null ? record.get("AB").replaceAll("\n", " ") : null;
        String type = record.get("PT");
        String doi = record.get("DI");
        String sourceIdentifier = record.get("UT");
        String volume = record.get("VL");
        String issue = record.get("IS");
        String beginPage = record.get("BP");
        String endPage = record.get("EP");
        int citations = record.get("TC") != null ? Integer.valueOf(record.get("TC")) : 0;
        return documentDAO.addDocument(title, docAbstract, type, citations, doi, sourceIdentifier, volume, issue, beginPage, endPage, false);
    }

    private void addAuthor(Integer documentID, TreeMap<String, String> record, AuthorDAO authorDAO, DocumentAuthorDAO documentAuthorDAO) throws KnowledgeBaseException {
        String authorNames = record.get("AU");
        String fullAuthorNames = record.get("AF");
        if (authorNames != null) {
            String[] splitAuthorName = authorNames.split("\n");
            String[] splitFullAuthorName = null;
            if (fullAuthorNames != null) {
                splitFullAuthorName = fullAuthorNames.split("\n");
            }
            for (int i = 0; i < splitAuthorName.length; ++i) {
                String fullAuthorName;
                String authorName;
                if (splitFullAuthorName != null) {
                    authorName = splitAuthorName[i];
                    fullAuthorName = splitFullAuthorName[i];
                } else {
                    authorName = splitAuthorName[i];
                    fullAuthorName = "";
                }
                Author author = authorDAO.getAuthor(authorName, fullAuthorName);
                Integer authorID = author == null ? authorDAO.addAuthor(authorName, fullAuthorName, false) : author.getAuthorID();
                if (documentAuthorDAO.checkDocumentAuthor(documentID, authorID)) continue;
                documentAuthorDAO.addDocumentAuthor(documentID, authorID, i + 1, false);
            }
        }
    }

    private void addAffiliation(Integer documentID, TreeMap<String, String> record, AffiliationDAO affiliationDAO, DocumentAffiliationDAO documentAffiliationDAO) throws KnowledgeBaseException {
        String fullAffiliations = record.get("C1");
        if (fullAffiliations != null) {
            String[] splitFullAffiliation = fullAffiliations.split("\n");
            for (int i = 0; i < splitFullAffiliation.length; ++i) {
                String fullAffiliation = splitFullAffiliation[i];
                Affiliation affiliation = affiliationDAO.getAffiliation(fullAffiliation);
                Integer affiliationID = affiliation == null ? affiliationDAO.addAffiliation(fullAffiliation, false) : affiliation.getAffiliationID();
                if (documentAffiliationDAO.checkDocumentAffiliation(documentID, affiliationID)) continue;
                documentAffiliationDAO.addDocumentAffiliation(documentID, affiliationID, false);
            }
        }
    }

    private Integer addJournal(Integer documentID, TreeMap<String, String> record, JournalDAO journalDAO, DocumentDAO documentDAO) throws KnowledgeBaseException {
        Integer journalID = null;
        String source = record.get("SO");
        String conferenceInformation = record.get("CT");
        if (source != null) {
            Journal journal = journalDAO.getJournal(source);
            journalID = journal == null ? journalDAO.addJournal(source, conferenceInformation, false) : journal.getJournalID();
            documentDAO.setJournal(documentID, journalID, false);
        }
        return journalID;
    }

    private Integer addPublishDate(Integer documentID, TreeMap<String, String> record, PublishDateDAO publishDateDAO, DocumentDAO documentDAO) throws KnowledgeBaseException {
        Integer publishDateID = null;
        String year = record.get("PY");
        String date = record.get("PD");
        if (date == null) {
            date = "";
        }
        if (year != null) {
            PublishDate publishDate = publishDateDAO.getPublishDate(year, date);
            publishDateID = publishDate == null ? publishDateDAO.addPublishDate(year, date, false) : publishDate.getPublishDateID();
            documentDAO.setPublishDate(documentID, publishDateID, false);
        }
        return publishDateID;
    }

    private void addSubjectCategory(Integer journalID, Integer publishDateID, TreeMap<String, String> record, SubjectCategoryDAO subjectCategoryDAO, JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO) throws KnowledgeBaseException {
        Integer subjectCategoryID = null;
        String subjectCategoryNames = record.get("SC");
        if (subjectCategoryNames != null) {
            String[] splitSC = subjectCategoryNames.replaceAll("\n", " ").split(";");
            for (int i = 0; i < splitSC.length; ++i) {
                String subjectCategoryName = splitSC[i].trim();
                SubjectCategory subjectCategory = subjectCategoryDAO.getSubjectCategory(subjectCategoryName);
                subjectCategoryID = subjectCategory == null ? subjectCategoryDAO.addSubjectCategory(subjectCategoryName, false) : subjectCategory.getSubjectCategoryID();
                if (journalID == null || publishDateID == null || journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(journalID, subjectCategoryID, publishDateID)) continue;
                journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(subjectCategoryID, journalID, publishDateID, false);
            }
        }
    }

    private void addReference(Integer documentID, TreeMap<String, String> record, ReferenceDAO referenceDAO, DocumentReferenceDAO documentReferenceDAO, AuthorReferenceDAO authorReferenceDAO, ReferenceSourceDAO referenceSourceDAO, AuthorReferenceReferenceDAO authorReferenceReferenceDAO) throws KnowledgeBaseException {
        String field = record.get("CR");
        if (field != null) {
            String[] splitField = record.get("CR").split("\n");
            for (int i = 0; i < splitField.length; ++i) {
                Integer referenceID;
                Reference reference;
                String fullReference = splitField[i];
                if (fullReference.endsWith(", DOI")) {
                    fullReference = fullReference + splitField[++i];
                }
                if ((reference = referenceDAO.getReference(fullReference)) == null) {
                    String doi;
                    String pages;
                    String volume;
                    String source;
                    String year;
                    String[] splitReference = fullReference.split(",");
                    String authorName = splitReference[0];
                    if (splitReference.length >= 3) {
                        year = splitReference[1].trim();
                        source = splitReference[2].trim();
                    } else {
                        year = "";
                        source = "";
                    }
                    if (splitReference.length >= 5) {
                        volume = splitReference[3].trim();
                        if (!volume.startsWith("V")) {
                            volume = "";
                        }
                        if (!(pages = splitReference[4].trim()).startsWith("P")) {
                            pages = "";
                        }
                    } else {
                        volume = "";
                        pages = "";
                    }
                    if (splitReference.length >= 6) {
                        doi = splitReference[5].trim();
                        if (!doi.startsWith("DOI")) {
                            doi = "";
                        }
                    } else {
                        doi = "";
                    }
                    referenceID = referenceDAO.addReference(fullReference, volume, "", pages, year, doi, "ISIWoS-1.0", false);
                    AuthorReference authorReference = authorReferenceDAO.getAuthorReference(authorName);
                    Integer authorReferenceID = authorReference == null ? authorReferenceDAO.addAuthorReference(authorName, false) : authorReference.getAuthorReferenceID();
                    authorReferenceReferenceDAO.addAuthorReferenceReference(referenceID, authorReferenceID, 1, false);
                    ReferenceSource referenceSource = referenceSourceDAO.getReferenceSource(source);
                    Integer referenceSourceID = referenceSource == null ? referenceSourceDAO.addReferenceSource(source, false) : referenceSource.getReferenceSourceID();
                    referenceDAO.setReferenceSource(referenceID, referenceSourceID, false);
                } else {
                    referenceID = reference.getReferenceID();
                }
                if (documentReferenceDAO.checkDocumentReference(documentID, referenceID)) continue;
                documentReferenceDAO.addDocumentReference(documentID, referenceID, false);
            }
        }
    }

    private void addWord(boolean authorWord, Integer documentID, TreeMap<String, String> record, WordDAO wordDAO, DocumentWordDAO documentWordDAO) throws KnowledgeBaseException {
        String wordNames = null;
        if (authorWord) {
            if (record.containsKey("DE")) {
                wordNames = record.get("DE").replaceAll("\n", " ");
            }
        } else if (record.containsKey("ID")) {
            wordNames = record.get("ID").replaceAll("\n", " ");
        }
        if (wordNames != null) {
            String[] splitWordName = wordNames.split(";");
            for (int i = 0; i < splitWordName.length; ++i) {
                String wordName = splitWordName[i].trim().toUpperCase().replaceAll(" ", "-");
                Word word = wordDAO.getWord(wordName);
                Integer wordID = word == null ? wordDAO.addWord(wordName, false) : word.getWordID();
                DocumentWord documentWord = documentWordDAO.getDocumentWord(documentID, wordID);
                if (documentWord != null) {
                    if (authorWord) {
                        documentWordDAO.setAuthorKeyword(documentID, wordID, true, false);
                        continue;
                    }
                    documentWordDAO.setSourceKeyword(documentID, wordID, true, false);
                    continue;
                }
                if (authorWord) {
                    documentWordDAO.addDocumentWord(documentID, wordID, true, false, false, false);
                    continue;
                }
                documentWordDAO.addDocumentWord(documentID, wordID, false, true, false, false);
            }
        }
    }
}

