/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.loader;

import com.csvreader.CsvReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import scimat.api.loader.GenericLoader;
import scimat.api.loader.LoaderException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.SubjectCategoryDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.SubjectCategory;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class CsvLoader
implements GenericLoader {
    private String file;
    private char delimiter;
    private boolean importReferences;
    private static final String __TITLE = "Title";
    private static final String __AUTHORS = "Authors";
    private static final String __AFFILIATIONS = "Affiliations";
    private static final String __ABSTRACT = "Abstract";
    private static final String __TYPE = "Type";
    private static final String __CITATIONS = "Citations";
    private static final String __JOURNAL = "Journal";
    private static final String __DOI = "Doi";
    private static final String __VOLUME = "Volume";
    private static final String __ISSUE = "Issue";
    private static final String __BEGIN_PAGE = "BeginPage";
    private static final String __END_PAGE = "EndPage";
    private static final String __YEAR = "Year";
    private static final String __FULL_PUBLISH_DATE = "FullPublishDate";
    private static final String __SOURCE_KEYWORDS = "SourceKeywords";
    private static final String __AUTHOR_KEYWORDS = "AuthorKeywords";
    private static final String __REFERENCES = "References";
    private static final String __SUBJECT_CATEGORIES = "SubjectCategories";

    public CsvLoader(String file, boolean importReferences) {
        this.file = file;
        this.delimiter = (char)44;
        this.importReferences = importReferences;
    }

    public CsvLoader(String file, char delimiter, boolean importReferences) {
        this.file = file;
        this.delimiter = delimiter;
        this.importReferences = importReferences;
    }

    public void execute(KnowledgeBaseManager kbm) throws LoaderException, KnowledgeBaseException {
        try {
            CsvReader records = new CsvReader(this.file, this.delimiter);
            records.readHeaders();
            records.setEscapeMode(1);
            this.addRecordToKnowledgeBase(records, kbm);
            kbm.commit();
            records.close();
            CurrentProject.getInstance().getKbObserver().fireKnowledgeBaseRefresh();
        }
        catch (FileNotFoundException fe) {
            throw new LoaderException(fe);
        }
        catch (IOException ioe) {
            throw new LoaderException(ioe);
        }
        catch (KnowledgeBaseException e) {
            try {
                kbm.getConnection().rollback();
            }
            catch (SQLException s) {
                throw new KnowledgeBaseException(s);
            }
            throw e;
        }
    }

    private void addRecordToKnowledgeBase(CsvReader records, KnowledgeBaseManager kbm) throws KnowledgeBaseException, IOException {
        AffiliationDAO affiliationDAO = new AffiliationDAO(kbm);
        AuthorDAO authorDAO = new AuthorDAO(kbm);
        AuthorReferenceDAO authorReferenceDAO = new AuthorReferenceDAO(kbm);
        AuthorReferenceReferenceDAO authorReferenceReferenceDAO = new AuthorReferenceReferenceDAO(kbm);
        DocumentAffiliationDAO documentAffiliationDAO = new DocumentAffiliationDAO(kbm);
        DocumentAuthorDAO documentAuthorDAO = new DocumentAuthorDAO(kbm);
        DocumentDAO documentDAO = new DocumentDAO(kbm);
        DocumentReferenceDAO documentReferenceDAO = new DocumentReferenceDAO(kbm);
        DocumentWordDAO documentWordDAO = new DocumentWordDAO(kbm);
        JournalDAO journalDAO = new JournalDAO(kbm);
        JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = new JournalSubjectCategoryPublishDateDAO(kbm);
        PublishDateDAO publishDateDAO = new PublishDateDAO(kbm);
        ReferenceDAO referenceDAO = new ReferenceDAO(kbm);
        ReferenceSourceDAO referenceSourceDAO = new ReferenceSourceDAO(kbm);
        SubjectCategoryDAO subjectCategoryDAO = new SubjectCategoryDAO(kbm);
        WordDAO wordDAO = new WordDAO(kbm);
        int i = 0;
        while (records.readRecord()) {
            System.out.println("Record " + (i + 1));
            Integer documentID = this.addDocument(records, documentDAO);
            if (documentID != null) {
                this.addAuthor(documentID, records, authorDAO, documentAuthorDAO);
                this.addAffiliation(documentID, records, affiliationDAO, documentAffiliationDAO);
                Integer journalID = this.addJournal(documentID, records, journalDAO, documentDAO);
                Integer publishDateID = this.addPublishDate(documentID, records, publishDateDAO, documentDAO);
                if (this.importReferences) {
                    this.addReference(documentID, records, referenceDAO, documentReferenceDAO, authorReferenceDAO, referenceSourceDAO, authorReferenceReferenceDAO);
                }
                this.addSubjectCategory(journalID, publishDateID, records, subjectCategoryDAO, journalSubjectCategoryPublishDateDAO);
                this.addWord(true, documentID, records, wordDAO, documentWordDAO);
                this.addWord(false, documentID, records, wordDAO, documentWordDAO);
            }
            ++i;
        }
    }

    private Integer addDocument(CsvReader records, DocumentDAO documentDAO) throws KnowledgeBaseException, IOException {
        Integer documentID;
        String title = records.get(__TITLE).replaceAll("\n", " ");
        if (!title.isEmpty()) {
            String docAbstract = records.get(__ABSTRACT);
            docAbstract = !docAbstract.isEmpty() ? docAbstract.replaceAll("\n", " ") : null;
            String type = records.get(__TYPE);
            String doi = records.get(__DOI);
            String sourceIdentifier = records.get("CSV");
            String volume = records.get(__VOLUME);
            String issue = records.get(__ISSUE);
            String beginPage = records.get(__BEGIN_PAGE);
            String endPage = records.get(__END_PAGE);
            int citations = !records.get(__CITATIONS).isEmpty() ? Integer.valueOf(records.get(__CITATIONS)) : 0;
            documentID = documentDAO.addDocument(title, docAbstract, type, citations, doi, sourceIdentifier, volume, issue, beginPage, endPage, false);
        } else {
            documentID = null;
        }
        return documentID;
    }

    private void addAuthor(Integer documentID, CsvReader record, AuthorDAO authorDAO, DocumentAuthorDAO documentAuthorDAO) throws KnowledgeBaseException, IOException {
        String authorNames = record.get(__AUTHORS);
        if (!authorNames.isEmpty()) {
            String[] splitAuthorName = authorNames.split("//");
            for (int i = 0; i < splitAuthorName.length; ++i) {
                String authorName = splitAuthorName[i];
                Author author = authorDAO.getAuthor(authorName, "");
                Integer authorID = author == null ? authorDAO.addAuthor(authorName, "", false) : author.getAuthorID();
                if (documentAuthorDAO.checkDocumentAuthor(documentID, authorID)) continue;
                documentAuthorDAO.addDocumentAuthor(documentID, authorID, i + 1, false);
            }
        }
    }

    private void addAffiliation(Integer documentID, CsvReader record, AffiliationDAO affiliationDAO, DocumentAffiliationDAO documentAffiliationDAO) throws KnowledgeBaseException, IOException {
        String fullAffiliations = record.get(__AFFILIATIONS);
        if (!fullAffiliations.isEmpty()) {
            String[] splitFullAffiliation = fullAffiliations.split("//");
            for (int i = 0; i < splitFullAffiliation.length; ++i) {
                String fullAffiliation = splitFullAffiliation[i];
                Affiliation affiliation = affiliationDAO.getAffiliation(fullAffiliation);
                Integer affiliationID = affiliation == null ? affiliationDAO.addAffiliation(fullAffiliation, false) : affiliation.getAffiliationID();
                if (documentAffiliationDAO.checkDocumentAffiliation(documentID, affiliationID)) continue;
                documentAffiliationDAO.addDocumentAffiliation(documentID, affiliationID, false);
            }
        }
    }

    private Integer addJournal(Integer documentID, CsvReader record, JournalDAO journalDAO, DocumentDAO documentDAO) throws KnowledgeBaseException, IOException {
        Integer journalID = null;
        String source = record.get(__JOURNAL);
        if (!source.isEmpty()) {
            Journal journal = journalDAO.getJournal(source);
            journalID = journal == null ? journalDAO.addJournal(source, "", false) : journal.getJournalID();
            documentDAO.setJournal(documentID, journalID, false);
        }
        return journalID;
    }

    private Integer addPublishDate(Integer documentID, CsvReader record, PublishDateDAO publishDateDAO, DocumentDAO documentDAO) throws KnowledgeBaseException, IOException {
        Integer publishDateID = null;
        String year = record.get(__YEAR);
        String date = record.get(__FULL_PUBLISH_DATE);
        if (!year.isEmpty()) {
            PublishDate publishDate = publishDateDAO.getPublishDate(year, date);
            publishDateID = publishDate == null ? publishDateDAO.addPublishDate(year, date, false) : publishDate.getPublishDateID();
            documentDAO.setPublishDate(documentID, publishDateID, false);
        }
        return publishDateID;
    }

    private void addSubjectCategory(Integer journalID, Integer publishDateID, CsvReader records, SubjectCategoryDAO subjectCategoryDAO, JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO) throws KnowledgeBaseException, IOException {
        Integer subjectCategoryID = null;
        String subjectCategoryNames = records.get(__SUBJECT_CATEGORIES);
        if (!subjectCategoryNames.isEmpty()) {
            String[] splitSC = subjectCategoryNames.split("//");
            for (int i = 0; i < splitSC.length; ++i) {
                String subjectCategoryName = splitSC[i].trim();
                SubjectCategory subjectCategory = subjectCategoryDAO.getSubjectCategory(subjectCategoryName);
                subjectCategoryID = subjectCategory == null ? subjectCategoryDAO.addSubjectCategory(subjectCategoryName, false) : subjectCategory.getSubjectCategoryID();
                if (journalID == null || publishDateID == null || journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(journalID, subjectCategoryID, publishDateID)) continue;
                journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(subjectCategoryID, journalID, publishDateID, false);
            }
        }
    }

    private void addReference(Integer documentID, CsvReader record, ReferenceDAO referenceDAO, DocumentReferenceDAO documentReferenceDAO, AuthorReferenceDAO authorReferenceDAO, ReferenceSourceDAO referenceSourceDAO, AuthorReferenceReferenceDAO authorReferenceReferenceDAO) throws KnowledgeBaseException, IOException {
        String references = record.get(__REFERENCES);
        if (!references.isEmpty()) {
            String[] splitField = references.split("//");
            for (int i = 0; i < splitField.length; ++i) {
                Integer referenceID;
                String fullReference = splitField[i];
                Reference reference = referenceDAO.getReference(fullReference);
                if (reference == null) {
                    ReferenceSource referenceSource;
                    String doi;
                    String pages;
                    String volume;
                    String source;
                    String year;
                    String[] splitReference = fullReference.split(",");
                    String authorName = splitReference[0];
                    if (splitReference.length >= 3) {
                        year = splitReference[1].trim();
                        source = splitReference[2].trim();
                    } else {
                        year = "";
                        source = "";
                    }
                    if (splitReference.length >= 5) {
                        volume = splitReference[3].trim();
                        if (!volume.startsWith("V")) {
                            volume = "";
                        }
                        if (!(pages = splitReference[4].trim()).startsWith("P")) {
                            pages = "";
                        }
                    } else {
                        volume = "";
                        pages = "";
                    }
                    if (splitReference.length >= 6) {
                        doi = splitReference[5].trim();
                        if (!doi.startsWith("DOI")) {
                            doi = "";
                        }
                    } else {
                        doi = "";
                    }
                    referenceID = referenceDAO.addReference(fullReference, volume, "", pages, year, doi, "ISIWoS-1.0", false);
                    AuthorReference authorReference = authorReferenceDAO.getAuthorReference(authorName);
                    Integer authorReferenceID = authorReference == null ? authorReferenceDAO.addAuthorReference(authorName, false) : authorReference.getAuthorReferenceID();
                    if (!authorReferenceReferenceDAO.checkAuthorReferenceReference(authorReferenceID, referenceID)) {
                        authorReferenceReferenceDAO.addAuthorReferenceReference(referenceID, authorReferenceID, 1, false);
                    }
                    Integer referenceSourceID = (referenceSource = referenceSourceDAO.getReferenceSource(source)) == null ? referenceSourceDAO.addReferenceSource(source, false) : referenceSource.getReferenceSourceID();
                    referenceDAO.setReferenceSource(referenceID, referenceSourceID, false);
                } else {
                    referenceID = reference.getReferenceID();
                }
                if (documentReferenceDAO.checkDocumentReference(documentID, referenceID)) continue;
                documentReferenceDAO.addDocumentReference(documentID, referenceID, false);
            }
        }
    }

    private void addWord(boolean authorWord, Integer documentID, CsvReader record, WordDAO wordDAO, DocumentWordDAO documentWordDAO) throws KnowledgeBaseException, IOException {
        String wordNames = null;
        wordNames = authorWord ? record.get(__AUTHOR_KEYWORDS) : record.get(__SOURCE_KEYWORDS);
        if (!wordNames.isEmpty()) {
            String[] splitWordName = wordNames.split("//");
            for (int i = 0; i < splitWordName.length; ++i) {
                String wordName = splitWordName[i].trim().toUpperCase().replaceAll(" ", "-");
                Word word = wordDAO.getWord(wordName);
                Integer wordID = word == null ? wordDAO.addWord(wordName, false) : word.getWordID();
                DocumentWord documentWord = documentWordDAO.getDocumentWord(documentID, wordID);
                if (documentWord != null) {
                    if (authorWord) {
                        documentWordDAO.setAuthorKeyword(documentID, wordID, true, false);
                        continue;
                    }
                    documentWordDAO.setSourceKeyword(documentID, wordID, true, false);
                    continue;
                }
                if (authorWord) {
                    documentWordDAO.addDocumentWord(documentID, wordID, true, false, false, false);
                    continue;
                }
                documentWordDAO.addDocumentWord(documentID, wordID, false, true, false, false);
            }
        }
    }

    private void showRecord(CsvReader records) {
        try {
            while (records.readRecord()) {
                System.out.println("Header1: " + records.get("header1"));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
}

