/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.imports;

import java.io.FileReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import scimat.api.imports.ImportException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceGroupDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class ImportGroupsXML {
    private KnowledgeBaseManager kbm;
    private String path;

    public ImportGroupsXML(KnowledgeBaseManager kbm, String path) {
        this.kbm = kbm;
        this.path = path;
    }

    public void execute() throws ImportException {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(new GroupsHandler());
            parser.parse(new InputSource(new FileReader(this.path)));
            this.kbm.commit();
        }
        catch (Exception e) {
            try {
                System.out.println("Doing rollback");
                this.kbm.rollback();
            }
            catch (KnowledgeBaseException kbe) {
                kbe.printStackTrace(System.err);
                throw new ImportException(kbe);
            }
            e.printStackTrace(System.err);
            throw new ImportException(e);
        }
    }

    private class GroupsHandler
    extends DefaultHandler {
        private static final String __GROUPS = "groups";
        private static final String __GROUP = "group";
        private static final String __GROUP_NAME = "name";
        private static final String __STOP_GROUP = "stop";
        private static final String __AUTHOR_GROUPS = "authorGroups";
        private static final String __AUTHORREFERENCE_GROUPS = "authorReferenceGroups";
        private static final String __REFERENCE_GROUPS = "referenceGroups";
        private static final String __REFERENCESOURCE_GROUPS = "referenceSourceGroups";
        private static final String __WORD_GROUPS = "wordGroups";
        private static final String __AUTHOR = "author";
        private static final String __AUTHOR_NAME = "authorName";
        private static final String __AUTHOR_FULL_NAME = "fullAuthorName";
        private static final String __AUTHORREFERENCE = "authorReference";
        private static final String __REFERENCE = "reference";
        private static final String __REFERENCESOURCE = "referenceSource";
        private static final String __WORD = "word";
        private StringBuffer currentValue = new StringBuffer();
        private String groupName = null;
        private String stopGroup = null;
        private String authorName = null;
        private String fullAuthorName = null;
        private String authorReferenceName = null;
        private String fullReference = null;
        private String source = null;
        private String wordName = null;
        private AuthorDAO authorDAO;
        private AuthorGroupDAO authorGroupDAO;
        private AuthorReferenceDAO authorReferenceDAO;
        private AuthorReferenceGroupDAO authorReferenceGroupDAO;
        private ReferenceDAO referenceDAO;
        private ReferenceGroupDAO referenceGroupDAO;
        private ReferenceSourceDAO referenceSourceDAO;
        private ReferenceSourceGroupDAO referenceSourceGroupDAO;
        private WordDAO wordDAO;
        private WordGroupDAO wordGroupDAO;
        private Author author;
        private AuthorGroup authorGroup;
        private AuthorReference authorReference;
        private AuthorReferenceGroup authorReferenceGroup;
        private Reference reference;
        private ReferenceGroup referenceGroup;
        private ReferenceSource referenceSource;
        private ReferenceSourceGroup referenceSourceGroup;
        private Word word;
        private WordGroup wordGroup;

        public GroupsHandler() throws KnowledgeBaseException {
            this.authorDAO = new AuthorDAO(ImportGroupsXML.this.kbm);
            this.authorGroupDAO = new AuthorGroupDAO(ImportGroupsXML.this.kbm);
            this.authorReferenceDAO = new AuthorReferenceDAO(ImportGroupsXML.this.kbm);
            this.authorReferenceGroupDAO = new AuthorReferenceGroupDAO(ImportGroupsXML.this.kbm);
            this.referenceDAO = new ReferenceDAO(ImportGroupsXML.this.kbm);
            this.referenceGroupDAO = new ReferenceGroupDAO(ImportGroupsXML.this.kbm);
            this.referenceSourceDAO = new ReferenceSourceDAO(ImportGroupsXML.this.kbm);
            this.referenceSourceGroupDAO = new ReferenceSourceGroupDAO(ImportGroupsXML.this.kbm);
            this.wordDAO = new WordDAO(ImportGroupsXML.this.kbm);
            this.wordGroupDAO = new WordGroupDAO(ImportGroupsXML.this.kbm);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentValue = new StringBuffer();
            if (!localName.equals(__GROUPS)) {
                if (localName.equals(__GROUP)) {
                    this.groupName = attributes.getValue(__GROUP_NAME);
                    if (this.groupName == null) {
                        throw new SAXException("The attribute name is requiered.");
                    }
                    this.groupName.trim();
                    this.stopGroup = attributes.getValue(__STOP_GROUP);
                    if (this.stopGroup == null) {
                        throw new SAXException("The attribute stop is requiered.");
                    }
                    this.stopGroup.trim();
                    this.authorName = null;
                    this.fullAuthorName = null;
                    this.authorReferenceName = null;
                    this.fullReference = null;
                    this.referenceSource = null;
                    this.wordName = null;
                } else if (localName.equals(__AUTHOR_GROUPS)) {
                    this.authorGroup = null;
                } else if (localName.equals(__AUTHOR)) {
                    this.author = null;
                } else if (localName.equals(__AUTHORREFERENCE_GROUPS)) {
                    this.authorReferenceGroup = null;
                } else if (localName.equals(__AUTHORREFERENCE)) {
                    this.authorReference = null;
                } else if (localName.equals(__REFERENCE_GROUPS)) {
                    this.referenceGroup = null;
                } else if (localName.equals(__REFERENCE)) {
                    this.reference = null;
                } else if (localName.equals(__REFERENCESOURCE_GROUPS)) {
                    this.referenceSourceGroup = null;
                } else if (localName.equals(__REFERENCESOURCE)) {
                    this.referenceSource = null;
                } else if (localName.equals(__WORD_GROUPS)) {
                    this.wordGroup = null;
                } else if (localName.equals(__WORD)) {
                    this.word = null;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (!localName.equals(__GROUPS)) {
                    if (localName.equals(__GROUP)) {
                        this.authorGroup = null;
                        this.authorReferenceGroup = null;
                        this.referenceGroup = null;
                        this.referenceSourceGroup = null;
                        this.wordGroup = null;
                    } else if (localName.equals(__AUTHOR_GROUPS)) {
                        this.authorGroup = null;
                    } else if (localName.equals(__AUTHOR)) {
                        this.author = this.authorDAO.getAuthor(this.authorName, this.fullAuthorName);
                        if (this.author != null) {
                            if (this.authorGroup == null) {
                                this.authorGroup = !this.authorGroupDAO.checkAuthorGroup(this.groupName) ? this.authorGroupDAO.getAuthorGroup(this.authorGroupDAO.addAuthorGroup(this.groupName, Boolean.getBoolean(this.stopGroup), false)) : this.authorGroupDAO.getAuthorGroup(this.groupName);
                            }
                            this.authorDAO.setAuthorGroup(this.author.getAuthorID(), this.authorGroup.getAuthorGroupID(), false);
                        }
                    } else if (localName.equals(__AUTHOR_NAME)) {
                        this.authorName = this.currentValue.toString().trim();
                    } else if (localName.equals(__AUTHOR_FULL_NAME)) {
                        this.fullAuthorName = this.currentValue.toString().trim();
                    } else if (localName.equals(__AUTHORREFERENCE_GROUPS)) {
                        this.authorReferenceGroup = null;
                    } else if (localName.equals(__AUTHORREFERENCE)) {
                        this.authorReferenceName = this.currentValue.toString().trim();
                        this.authorReference = this.authorReferenceDAO.getAuthorReference(this.authorReferenceName);
                        if (this.authorReference != null) {
                            if (this.authorReferenceGroup == null) {
                                this.authorReferenceGroup = !this.authorReferenceGroupDAO.checkAuthorReferenceGroup(this.groupName) ? this.authorReferenceGroupDAO.getAuthorReferenceGroup(this.authorReferenceGroupDAO.addAuthorReferenceGroup(this.groupName, Boolean.getBoolean(this.stopGroup), false)) : this.authorReferenceGroupDAO.getAuthorReferenceGroup(this.groupName);
                            }
                            this.authorReferenceDAO.setAuthorReferenceGroup(this.authorReference.getAuthorReferenceID(), this.authorReferenceGroup.getAuthorReferenceGroupID(), false);
                        }
                    } else if (localName.equals(__REFERENCE_GROUPS)) {
                        this.referenceGroup = null;
                    } else if (localName.equals(__REFERENCE)) {
                        this.fullReference = this.currentValue.toString().trim();
                        this.reference = this.referenceDAO.getReference(this.fullReference);
                        if (this.reference != null) {
                            if (this.referenceGroup == null) {
                                this.referenceGroup = !this.referenceGroupDAO.checkReferenceGroup(this.groupName) ? this.referenceGroupDAO.getReferenceGroup(this.referenceGroupDAO.addReferenceGroup(this.groupName, Boolean.getBoolean(this.stopGroup), false)) : this.referenceGroupDAO.getReferenceGroup(this.groupName);
                            }
                            this.referenceDAO.setReferenceGroup(this.reference.getReferenceID(), this.referenceGroup.getReferenceGroupID(), false);
                        }
                    } else if (localName.equals(__REFERENCESOURCE_GROUPS)) {
                        this.referenceSourceGroup = null;
                    } else if (localName.equals(__REFERENCESOURCE)) {
                        this.source = this.currentValue.toString().trim();
                        this.referenceSource = this.referenceSourceDAO.getReferenceSource(this.source);
                        if (this.referenceSource != null) {
                            if (this.referenceSourceGroup == null) {
                                this.referenceSourceGroup = !this.referenceSourceGroupDAO.checkReferenceSourceGroup(this.groupName) ? this.referenceSourceGroupDAO.getReferenceSourceGroup(this.referenceSourceGroupDAO.addReferenceSourceGroup(this.groupName, Boolean.getBoolean(this.stopGroup), false)) : this.referenceSourceGroupDAO.getReferenceSourceGroup(this.groupName);
                            }
                            this.referenceSourceDAO.setReferenceSourceGroup(this.referenceSource.getReferenceSourceID(), this.referenceSourceGroup.getReferenceSourceGroupID(), false);
                        }
                    } else if (localName.equals(__WORD_GROUPS)) {
                        this.wordGroup = null;
                    } else if (localName.equals(__WORD)) {
                        this.wordName = this.currentValue.toString().trim();
                        this.word = this.wordDAO.getWord(this.wordName);
                        if (this.word != null) {
                            if (this.wordGroup == null) {
                                this.wordGroup = !this.wordGroupDAO.checkWordGroup(this.groupName) ? this.wordGroupDAO.getWordGroup(this.wordGroupDAO.addWordGroup(this.groupName, Boolean.getBoolean(this.stopGroup), false)) : this.wordGroupDAO.getWordGroup(this.groupName);
                            }
                            this.wordDAO.setWordGroup(this.word.getWordID(), this.wordGroup.getWordGroupID(), false);
                        }
                    }
                }
            }
            catch (KnowledgeBaseException kbe) {
                throw new SAXException(kbe);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentValue.append(ch, start, length);
        }
    }
}

