/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.export;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import scimat.api.export.ExportException;
import scimat.api.export.GenericExporter;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceGroupDAO;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class ExportGroupsXML
implements GenericExporter {
    private String path;

    public ExportGroupsXML(String path) {
        this.path = path;
    }

    public void execute() throws ExportException {
        try {
            int j;
            int i;
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            PrintStream out = new PrintStream(this.path);
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<groups>");
            ArrayList<AuthorGroup> authorGroups = authorGroupDAO.getAuthorGroups();
            out.println("  <authorGroups>");
            for (i = 0; i < authorGroups.size(); ++i) {
                AuthorGroup authorGroup = authorGroups.get(i);
                out.println("    <group name=\"" + StringEscapeUtils.escapeXml((String)authorGroup.getGroupName()) + "\" stop=\"" + authorGroup.isStopGroup() + "\">");
                ArrayList<Author> authors = authorGroupDAO.getAuthors(authorGroup.getAuthorGroupID());
                for (j = 0; j < authors.size(); ++j) {
                    out.println("      <author>");
                    out.println("        <authorName>" + StringEscapeUtils.escapeXml((String)authors.get(j).getAuthorName()) + "</authorName>");
                    out.println("        <fullAuthorName>" + StringEscapeUtils.escapeXml((String)authors.get(j).getFullAuthorName()) + "</fullAuthorName>");
                    out.println("      </author>");
                }
                out.println("    </group>");
            }
            out.println("  </authorGroups>");
            ArrayList<AuthorReferenceGroup> authorReferenceGroups = authorReferenceGroupDAO.getAuthorReferenceGroups();
            out.println("  <authorReferenceGroups>");
            for (i = 0; i < authorReferenceGroups.size(); ++i) {
                AuthorReferenceGroup authorReferenceGroup = authorReferenceGroups.get(i);
                out.println("    <group name=\"" + StringEscapeUtils.escapeXml((String)authorReferenceGroup.getGroupName()) + "\" stop=\"" + authorReferenceGroup.isStopGroup() + "\">");
                ArrayList<AuthorReference> authorReferences = authorReferenceGroupDAO.getAuthorReferences(authorReferenceGroup.getAuthorReferenceGroupID());
                for (j = 0; j < authorReferences.size(); ++j) {
                    out.println("      <authorReference>" + StringEscapeUtils.escapeXml((String)authorReferences.get(j).getAuthorName()) + "</authorReference>");
                }
                out.println("    </group>");
            }
            out.println("  </authorReferenceGroups>");
            ArrayList<ReferenceGroup> referenceGroups = referenceGroupDAO.getReferenceGroups();
            out.println("  <referenceGroups>");
            for (i = 0; i < referenceGroups.size(); ++i) {
                ReferenceGroup referenceGroup = referenceGroups.get(i);
                out.println("    <group name=\"" + StringEscapeUtils.escapeXml((String)referenceGroup.getGroupName()) + "\" stop=\"" + referenceGroup.isStopGroup() + "\">");
                ArrayList<Reference> references = referenceGroupDAO.getReferences(referenceGroup.getReferenceGroupID());
                for (j = 0; j < references.size(); ++j) {
                    out.println("      <reference>" + StringEscapeUtils.escapeXml((String)references.get(j).getFullReference()) + "</reference>");
                }
                out.println("    </group>");
            }
            out.println("  </referenceGroups>");
            ArrayList<ReferenceSourceGroup> referenceSourceGroups = referenceSourceGroupDAO.getReferenceSourceGroups();
            out.println("  <referenceSourceGroups>");
            for (i = 0; i < referenceSourceGroups.size(); ++i) {
                ReferenceSourceGroup referenceSourceGroup = referenceSourceGroups.get(i);
                out.println("    <group name=\"" + StringEscapeUtils.escapeXml((String)referenceSourceGroup.getGroupName()) + "\" stop=\"" + referenceSourceGroup.isStopGroup() + "\">");
                ArrayList<ReferenceSource> referenceSources = referenceSourceGroupDAO.getReferenceSources(referenceSourceGroup.getReferenceSourceGroupID());
                for (j = 0; j < referenceSources.size(); ++j) {
                    out.println("      <referenceSource>" + StringEscapeUtils.escapeXml((String)referenceSources.get(j).getSource()) + "</referenceSource>");
                }
                out.println("    </group>");
            }
            out.println("  </referenceSourceGroups>");
            ArrayList<WordGroup> wordGroups = wordGroupDAO.getWordGroups();
            out.println("  <wordGroups>");
            for (i = 0; i < wordGroups.size(); ++i) {
                WordGroup wordGroup = wordGroups.get(i);
                out.println("    <group name=\"" + StringEscapeUtils.escapeXml((String)wordGroup.getGroupName()) + "\" stop=\"" + wordGroup.isStopGroup() + "\">");
                ArrayList<Word> words = wordGroupDAO.getWords(wordGroup.getWordGroupID());
                for (j = 0; j < words.size(); ++j) {
                    out.println("      <word>" + StringEscapeUtils.escapeXml((String)words.get(j).getWordName()) + "</word>");
                }
                out.println("    </group>");
            }
            out.println("  </wordGroups>");
            out.println("</groups>");
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new ExportException(fnfe);
        }
        catch (KnowledgeBaseException kbe) {
            throw new ExportException(kbe);
        }
    }
}

