/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.export;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDocumentsReferenceFormat {
    private KnowledgeBaseManager kmb;
    private ArrayList<Document> documents;
    private String file;

    public ExportDocumentsReferenceFormat(KnowledgeBaseManager kmb, ArrayList<Document> documents, String file) {
        this.kmb = kmb;
        this.documents = documents;
        this.file = file;
    }

    public void execute() throws KnowledgeBaseException, FileNotFoundException {
        DocumentDAO documentDAO = new DocumentDAO(this.kmb);
        PrintStream out = new PrintStream(this.file);
        for (int i = 0; i < this.documents.size(); ++i) {
            Document document = this.documents.get(i);
            ArrayList<Author> authors = documentDAO.getAuthors(document.getDocumentID());
            Journal journal = documentDAO.getJournal(document.getDocumentID());
            PublishDate publishDate = documentDAO.getPublishDate(document.getDocumentID());
            for (int j = 0; j < authors.size(); ++j) {
                out.print(authors.get(j).getAuthorName() + ", ");
            }
            out.print(document.getTitle() + ". ");
            if (journal != null) {
                out.print(journal.getSource() + " ");
                out.print(document.getVolume() + ":");
                out.print(document.getIssue() + " ");
                out.print(document.getBeginPage() + "-");
                out.print(document.getEndPage() + " ");
            }
            if (publishDate != null) {
                out.print("(" + publishDate.getYear() + ") ");
            }
            out.println("Times cited: " + document.getCitationsCount());
        }
        out.close();
    }
}

