/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.networkbuilder;

import java.util.ArrayList;
import java.util.TreeSet;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.dataset.networkbuilder.NetworkBuilder;

public class NetworkCouplingBuilder
implements NetworkBuilder {
    private Dataset dataset;

    public NetworkCouplingBuilder(Dataset dataset) {
        this.dataset = dataset;
    }

    public UndirectNetworkMatrix execute() throws NotExistsItemException {
        ArrayList<Integer> docs = this.dataset.getDocuments();
        UndirectNetworkMatrix network = new UndirectNetworkMatrix(docs);
        for (int i = 0; i < docs.size(); ++i) {
            TreeSet<Integer> items = new TreeSet<Integer>(this.dataset.getItemsInDocument(docs.get(i)));
            for (int j = i + 1; j < docs.size(); ++j) {
                TreeSet<Integer> tmp = new TreeSet<Integer>(this.dataset.getItemsInDocument(docs.get(j)));
                tmp.retainAll(items);
                network.addEdge(docs.get(i), docs.get(j), tmp.size());
            }
        }
        return network;
    }
}

