/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.networkbuilder;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.dataset.networkbuilder.NetworkBuilder;

public class NetworkCoOccurrenceBuilder
implements NetworkBuilder {
    private Dataset dataset;

    public NetworkCoOccurrenceBuilder(Dataset dataset) {
        this.dataset = dataset;
    }

    public UndirectNetworkMatrix execute() {
        UndirectNetworkMatrix network = new UndirectNetworkMatrix(this.dataset.getItems());
        ArrayList<Integer> docs = this.dataset.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            try {
                ArrayList<Integer> items = this.dataset.getItemsInDocument(docs.get(i));
                for (int j = 0; j < items.size(); ++j) {
                    for (int k = j + 1; k < items.size(); ++k) {
                        Double value = network.getEdge(items.get(j), items.get(k));
                        network.addEdge(items.get(j), items.get(k), value + 1.0);
                    }
                }
                continue;
            }
            catch (NotExistsItemException e) {
                System.err.println("An internal error happens. The document " + docs.get(i) + " does not exist in the dataset.");
                e.printStackTrace(System.err);
            }
        }
        return network;
    }
}

