/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.networkbuilder;

import java.util.ArrayList;
import java.util.TreeSet;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.api.dataset.networkbuilder.NetworkBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAggregatedCouplingBuilder
implements NetworkBuilder {
    private AggregatedDataset aggregatedDataset;

    public NetworkAggregatedCouplingBuilder(AggregatedDataset aggregatedDataset) {
        this.aggregatedDataset = aggregatedDataset;
    }

    @Override
    public UndirectNetworkMatrix execute() throws NotExistsItemException {
        ArrayList<Integer> highLevelItems = this.aggregatedDataset.getHighLevelItems();
        UndirectNetworkMatrix network = new UndirectNetworkMatrix(highLevelItems);
        for (int i = 0; i < highLevelItems.size(); ++i) {
            TreeSet<Integer> items = this.getAggregatedItems(highLevelItems.get(i));
            TreeSet<Object> tmp = new TreeSet();
            for (int j = i + 1; j < highLevelItems.size(); ++j) {
                tmp = this.getAggregatedItems(highLevelItems.get(j));
                tmp.retainAll(items);
                network.addEdge(highLevelItems.get(i), highLevelItems.get(j), tmp.size());
            }
        }
        return network;
    }

    private TreeSet<Integer> getAggregatedItems(Integer highLevelItem) {
        ArrayList<Integer> docs = this.aggregatedDataset.getDocumentsInHighLevelItem(highLevelItem);
        TreeSet<Integer> items = new TreeSet<Integer>();
        for (int j = 0; j < docs.size(); ++j) {
            items.addAll(this.aggregatedDataset.getItemsInDocument(docs.get(j)));
        }
        return items;
    }
}

