/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.datasetbuilder;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.datasetbuilder.DatasetBuilder;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetBasedOnWordsBuilder
implements DatasetBuilder {
    private KnowledgeBaseManager kbm;
    private boolean authorKeyword;
    private boolean sourceKeyword;
    private boolean addedKeyword;

    public DatasetBasedOnWordsBuilder(KnowledgeBaseManager kbm, boolean authorKeyword, boolean sourceKeyword, boolean addedKeyword) {
        this.kbm = kbm;
        this.authorKeyword = authorKeyword;
        this.sourceKeyword = sourceKeyword;
        this.addedKeyword = addedKeyword;
    }

    @Override
    public Dataset execute(ArrayList<PublishDate> publishDateList) throws KnowledgeBaseException {
        PublishDateDAO publishDateDAO = new PublishDateDAO(this.kbm);
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        WordDAO wordDAO = new WordDAO(this.kbm);
        Dataset dataset = new Dataset();
        for (int i = 0; i < publishDateList.size(); ++i) {
            ArrayList<Document> documentsList = publishDateDAO.getDocuments(publishDateList.get(i).getPublishDateID());
            for (int j = 0; j < documentsList.size(); ++j) {
                Document document = documentsList.get(j);
                dataset.addDocument(document.getDocumentID(), document.getCitationsCount());
                ArrayList<Word> wordsList = documentDAO.getWords(document.getDocumentID(), this.authorKeyword, this.sourceKeyword, this.addedKeyword);
                for (int k = 0; k < wordsList.size(); ++k) {
                    Word word = wordsList.get(k);
                    WordGroup wordGroup = wordDAO.getWordGroup(word.getWordID());
                    if (wordGroup == null || wordGroup.isStopGroup()) continue;
                    try {
                        dataset.addItemToDocument(document.getDocumentID(), wordGroup.getWordGroupID(), wordGroup.getGroupName());
                        continue;
                    }
                    catch (NotExistsItemException e) {
                        System.err.println("An internal error occurs within the dataset construction. The document " + document.getDocumentID() + " does not exist.");
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return dataset;
    }
}

