/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.datasetbuilder;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.datasetbuilder.DatasetBuilder;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetBasedOnReferencesBuilder
implements DatasetBuilder {
    private KnowledgeBaseManager kbm;

    public DatasetBasedOnReferencesBuilder(KnowledgeBaseManager kbm) {
        this.kbm = kbm;
    }

    @Override
    public Dataset execute(ArrayList<PublishDate> publishDateList) throws KnowledgeBaseException {
        PublishDateDAO publishDateDAO = new PublishDateDAO(this.kbm);
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        ReferenceDAO referenceDAO = new ReferenceDAO(this.kbm);
        Dataset dataset = new Dataset();
        for (int i = 0; i < publishDateList.size(); ++i) {
            ArrayList<Document> documentsList = publishDateDAO.getDocuments(publishDateList.get(i).getPublishDateID());
            for (int j = 0; j < documentsList.size(); ++j) {
                Document document = documentsList.get(j);
                dataset.addDocument(document.getDocumentID(), document.getCitationsCount());
                ArrayList<Reference> referencesList = documentDAO.getReferences(document.getDocumentID());
                for (int k = 0; k < referencesList.size(); ++k) {
                    Reference reference = referencesList.get(k);
                    ReferenceGroup referenceGroup = referenceDAO.getReferenceGroup(reference.getReferenceID());
                    if (referenceGroup == null || referenceGroup.isStopGroup()) continue;
                    try {
                        dataset.addItemToDocument(document.getDocumentID(), referenceGroup.getReferenceGroupID(), referenceGroup.getGroupName());
                        continue;
                    }
                    catch (NotExistsItemException e) {
                        System.err.println("An internal error occurs within the dataset construction. The document " + document.getDocumentID() + " does not exist.");
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return dataset;
    }
}

