/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.datasetbuilder;

import java.util.ArrayList;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.datasetbuilder.DatasetBuilder;
import scimat.api.dataset.exception.NotExistsItemException;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetBasedOnAuthorsBuilder
implements DatasetBuilder {
    private KnowledgeBaseManager kbm;

    public DatasetBasedOnAuthorsBuilder(KnowledgeBaseManager kbm) {
        this.kbm = kbm;
    }

    @Override
    public Dataset execute(ArrayList<PublishDate> publishDateList) throws KnowledgeBaseException {
        PublishDateDAO publishDateDAO = new PublishDateDAO(this.kbm);
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        AuthorDAO authorDAO = new AuthorDAO(this.kbm);
        Dataset dataset = new Dataset();
        for (int i = 0; i < publishDateList.size(); ++i) {
            ArrayList<Document> documentsList = publishDateDAO.getDocuments(publishDateList.get(i).getPublishDateID());
            for (int j = 0; j < documentsList.size(); ++j) {
                Document document = documentsList.get(j);
                dataset.addDocument(document.getDocumentID(), document.getCitationsCount());
                ArrayList<DocumentAuthor> authorsList = documentDAO.getDocumentAuthors(document.getDocumentID());
                for (int k = 0; k < authorsList.size(); ++k) {
                    Author author = authorsList.get(k).getAuthor();
                    AuthorGroup authorGroup = authorDAO.getAuthorGroup(author.getAuthorID());
                    if (authorGroup == null || authorGroup.isStopGroup()) continue;
                    try {
                        dataset.addItemToDocument(document.getDocumentID(), authorGroup.getAuthorGroupID(), authorGroup.getGroupName());
                        continue;
                    }
                    catch (NotExistsItemException e) {
                        System.err.println("An internal error occurs within the dataset construction. The document " + document.getDocumentID() + " does not exist.");
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return dataset;
    }
}

