/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.datasetbuilder;

import java.util.ArrayList;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.datasetbuilder.AggregatedDatasetBuilder;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class AggregatedDatasetByJournalBuilder
implements AggregatedDatasetBuilder {
    private KnowledgeBaseManager kbm;

    public AggregatedDatasetByJournalBuilder(KnowledgeBaseManager kbm) {
        this.kbm = kbm;
    }

    public AggregatedDataset execute(Dataset dataset) throws KnowledgeBaseException {
        AggregatedDataset aggregatedDataset = new AggregatedDataset(dataset);
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        ArrayList<Integer> documents = dataset.getDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            Integer docID = documents.get(i);
            Journal journal = documentDAO.getJournal(docID);
            if (journal == null) continue;
            aggregatedDataset.addHighLevelItem(journal.getJournalID(), journal.getSource());
            aggregatedDataset.addDocumentToHighLevelItem(journal.getJournalID(), docID);
        }
        return aggregatedDataset;
    }
}

