/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset.datasetbuilder;

import java.util.ArrayList;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.datasetbuilder.AggregatedDatasetBuilder;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class AggregatedDatasetByAuthorBuilder
implements AggregatedDatasetBuilder {
    private KnowledgeBaseManager kbm;

    public AggregatedDatasetByAuthorBuilder(KnowledgeBaseManager kbm) {
        this.kbm = kbm;
    }

    public AggregatedDataset execute(Dataset dataset) throws KnowledgeBaseException {
        AggregatedDataset aggregatedDataset = new AggregatedDataset(dataset);
        DocumentDAO documentDAO = new DocumentDAO(this.kbm);
        ArrayList<Integer> documents = dataset.getDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            Integer docID = documents.get(i);
            ArrayList<DocumentAuthor> documentAuthors = documentDAO.getDocumentAuthors(docID);
            for (int j = 0; j < documentAuthors.size(); ++j) {
                DocumentAuthor documentAuthor = documentAuthors.get(j);
                aggregatedDataset.addHighLevelItem(documentAuthor.getAuthor().getAuthorID(), documentAuthor.getAuthor().getAuthorName());
                aggregatedDataset.addDocumentToHighLevelItem(documentAuthor.getAuthor().getAuthorID(), docID);
            }
        }
        return aggregatedDataset;
    }
}

