/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import scimat.api.dataset.NetworkPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndirectNetworkMatrix
implements Serializable,
Cloneable {
    private TreeMap<Integer, TreeMap<Integer, Double>> matrix = new TreeMap();
    private TreeSet<Integer> nodesList;

    public UndirectNetworkMatrix(ArrayList<Integer> nodesList) {
        this.nodesList = new TreeSet<Integer>(nodesList);
    }

    public boolean addEdge(Integer nodeSource, Integer nodeTarget, double value) {
        if (this.nodesList.contains(nodeSource) && this.nodesList.contains(nodeTarget)) {
            this.addSingleEdge(nodeSource, nodeTarget, value);
            this.addSingleEdge(nodeTarget, nodeSource, value);
            return true;
        }
        return false;
    }

    public boolean removeEdge(Integer nodeSource, Integer nodeTarget) {
        if (this.nodesList.contains(nodeSource) && this.nodesList.contains(nodeTarget)) {
            this.removeSingleEdge(nodeSource, nodeTarget);
            return this.removeSingleEdge(nodeTarget, nodeSource);
        }
        return false;
    }

    public double getEdge(Integer nodeSource, Integer nodeTarget) {
        TreeMap<Integer, Double> tmp = this.matrix.get(nodeSource);
        if (tmp != null) {
            Double value = tmp.get(nodeTarget);
            if (value != null) {
                return value;
            }
            return 0.0;
        }
        return 0.0;
    }

    public ArrayList<NetworkPair> getNetworkPairs() {
        ArrayList<NetworkPair> pairList = new ArrayList<NetworkPair>();
        for (Integer firstElementID : this.matrix.keySet()) {
            NavigableMap<Integer, Double> tmpMap = this.matrix.get(firstElementID).tailMap(firstElementID, false);
            for (Integer secondElementID : tmpMap.keySet()) {
                pairList.add(new NetworkPair(firstElementID, secondElementID, (Double)tmpMap.get(secondElementID)));
            }
        }
        return pairList;
    }

    public ArrayList<NetworkPair> getInternalPairs(ArrayList<Integer> nodes) {
        ArrayList<NetworkPair> pairs = new ArrayList<NetworkPair>();
        TreeSet<Integer> nodesToDelete = new TreeSet<Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            Integer nodeSourceID = nodes.get(i);
            TreeMap<Integer, Double> tmpMap = this.matrix.get(nodeSourceID);
            nodesToDelete.add(nodeSourceID);
            TreeSet<Integer> possiblePair = new TreeSet<Integer>(tmpMap.keySet());
            possiblePair.retainAll(nodes);
            possiblePair.removeAll(nodesToDelete);
            for (Integer nodeTargetID : possiblePair) {
                pairs.add(new NetworkPair(nodeSourceID, nodeTargetID, tmpMap.get(nodeTargetID)));
            }
        }
        return pairs;
    }

    public ArrayList<NetworkPair> getExternalPairs(ArrayList<Integer> nodes) {
        ArrayList<NetworkPair> pairs = new ArrayList<NetworkPair>();
        for (int i = 0; i < nodes.size(); ++i) {
            Integer nodeSourceID = nodes.get(i);
            TreeMap<Integer, Double> tmpMap = this.matrix.get(nodeSourceID);
            TreeSet<Integer> possiblePair = new TreeSet<Integer>(tmpMap.keySet());
            possiblePair.removeAll(nodes);
            for (Integer nodeTargetID : possiblePair) {
                pairs.add(new NetworkPair(nodeSourceID, nodeTargetID, tmpMap.get(nodeTargetID)));
            }
        }
        return pairs;
    }

    public ArrayList<NetworkPair> getIntraNodesPairs(ArrayList<Integer> nodesSource, ArrayList<Integer> nodesTarget) {
        ArrayList<NetworkPair> pairs = new ArrayList<NetworkPair>();
        for (int i = 0; i < nodesSource.size(); ++i) {
            Integer nodeCluster1ID = nodesSource.get(i);
            for (int j = 0; j < nodesTarget.size(); ++j) {
                Integer nodeCluster2ID = nodesTarget.get(j);
                Double value = this.getEdge(nodeCluster1ID, nodeCluster2ID);
                if (value == null) continue;
                pairs.add(new NetworkPair(nodeCluster1ID, nodeCluster2ID, value));
            }
        }
        return pairs;
    }

    public int getNodesCount() {
        return this.nodesList.size();
    }

    public ArrayList<Integer> getNodes() {
        return new ArrayList<Integer>(this.nodesList);
    }

    public boolean containsNode(Integer nodeID) {
        return this.nodesList.contains(nodeID);
    }

    public boolean containsEdge(Integer nodeSource, Integer nodeTarget) {
        TreeMap<Integer, Double> tmpMap = this.matrix.get(nodeSource);
        if (tmpMap != null) {
            return tmpMap.containsKey(nodeTarget);
        }
        return false;
    }

    public ArrayList<Integer> getNeighbours(Integer node) {
        if (this.matrix.containsKey(node)) {
            return new ArrayList<Integer>(this.matrix.get(node).keySet());
        }
        return new ArrayList<Integer>();
    }

    private void addSingleEdge(Integer nodeSource, Integer nodeTarget, double value) {
        TreeMap<Integer, Double> tmp = this.matrix.get(nodeSource);
        if (tmp == null) {
            tmp = new TreeMap();
            this.matrix.put(nodeSource, tmp);
        }
        tmp.put(nodeTarget, value);
    }

    private boolean removeSingleEdge(Integer nodeSource, Integer nodeTarget) {
        boolean flag;
        TreeMap<Integer, Double> tmp = this.matrix.get(nodeSource);
        if (tmp != null) {
            flag = tmp.remove(nodeTarget) != null;
            if (tmp.isEmpty()) {
                this.matrix.remove(nodeSource);
            }
        } else {
            flag = false;
        }
        return flag;
    }

    protected UndirectNetworkMatrix clone() throws CloneNotSupportedException {
        UndirectNetworkMatrix undirectNetworkMatrix = new UndirectNetworkMatrix(new ArrayList<Integer>(this.nodesList));
        undirectNetworkMatrix.matrix = new TreeMap<Integer, TreeMap<Integer, Double>>((SortedMap<Integer, TreeMap<Integer, Double>>)this.matrix);
        return undirectNetworkMatrix;
    }
}

