/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocItemElement
implements Serializable,
Cloneable {
    private Integer docID;
    private int timesCited;
    private TreeSet<Integer> items = new TreeSet();

    public DocItemElement(Integer docID) {
        this.docID = docID;
        this.timesCited = 0;
    }

    public DocItemElement(Integer docID, int timesCited) {
        this.docID = docID;
        this.timesCited = timesCited;
    }

    public DocItemElement(DocItemElement docItemElement) {
        this.docID = docItemElement.docID;
        this.timesCited = docItemElement.timesCited;
        this.items = new TreeSet<Integer>((SortedSet<Integer>)docItemElement.items);
    }

    public Integer getDocID() {
        return this.docID;
    }

    public int getTimesCited() {
        return this.timesCited;
    }

    public boolean addItem(Integer itemID) {
        return this.items.add(itemID);
    }

    public boolean containsItem(Integer itemID) {
        return this.items.contains(itemID);
    }

    public boolean removeItem(Integer itemID) {
        return this.items.remove(itemID);
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public ArrayList<Integer> getItemsList() {
        return new ArrayList<Integer>(this.items);
    }

    protected DocItemElement clone() {
        DocItemElement docItemElement = new DocItemElement(this.docID, this.timesCited);
        docItemElement.items = new TreeSet<Integer>((SortedSet<Integer>)this.items);
        return docItemElement;
    }

    public String toString() {
        String result = "";
        result = result + "(";
        result = result + "DocID: " + this.docID;
        result = result + "Times cited: " + this.timesCited;
        result = result + "Items: " + this.items;
        result = result + ")";
        return result;
    }
}

