/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.dataset.DocItemElement;
import scimat.api.dataset.ItemDocElement;
import scimat.api.dataset.exception.NotExistsItemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
implements Serializable,
Cloneable {
    private TreeMap<Integer, DocItemElement> docs = new TreeMap();
    private TreeMap<Integer, ItemDocElement> items = new TreeMap();

    public Dataset() {
    }

    public Dataset(Dataset dataset) {
        for (Integer id : dataset.docs.keySet()) {
            this.docs.put(id, dataset.docs.get(id).clone());
        }
        for (Integer id : dataset.items.keySet()) {
            this.items.put(id, dataset.items.get(id).clone());
        }
    }

    public boolean addDocument(Integer docID, int timesCited) {
        if (this.docs.containsKey(docID)) {
            return false;
        }
        this.docs.put(docID, new DocItemElement(docID, timesCited));
        return true;
    }

    public boolean addDocument(Integer docID) {
        if (this.docs.containsKey(docID)) {
            return false;
        }
        this.docs.put(docID, new DocItemElement(docID));
        return true;
    }

    public ArrayList<Integer> getDocuments() {
        return new ArrayList<Integer>(this.docs.keySet());
    }

    public boolean containsDocument(Integer docID) {
        return this.docs.containsKey(docID);
    }

    public ArrayList<Integer> getItems() {
        return new ArrayList<Integer>(this.items.keySet());
    }

    public boolean containsItem(Integer itemID) {
        return this.items.containsKey(itemID);
    }

    public ArrayList<Integer> getItemsInDocument(Integer docID) throws NotExistsItemException {
        DocItemElement doc = this.docs.get(docID);
        if (doc != null) {
            return new ArrayList<Integer>(doc.getItemsList());
        }
        throw new NotExistsItemException("The document " + docID + " does " + "not exist in the dataset.");
    }

    public ArrayList<Integer> getDocumentsInItem(Integer itemID) throws NotExistsItemException {
        ItemDocElement item = this.items.get(itemID);
        if (item != null) {
            return new ArrayList<Integer>(item.getDocumentsList());
        }
        throw new NotExistsItemException("The item " + itemID + " does " + "not exist in the dataset.");
    }

    public int getDocumentsInItemCount(Integer itemID) throws NotExistsItemException {
        ItemDocElement item = this.items.get(itemID);
        if (item != null) {
            return item.getDocumentsCount();
        }
        throw new NotExistsItemException("The item " + itemID + " does " + "not exist in the dataset.");
    }

    public void removeDocument(Integer docID) throws NotExistsItemException {
        DocItemElement doc = this.docs.remove(docID);
        if (doc != null) {
            ArrayList<Integer> itemList = doc.getItemsList();
            for (int i = 0; i < itemList.size(); ++i) {
                ItemDocElement item = this.items.get(itemList.get(i));
                item.removeDocument(docID);
            }
        } else {
            throw new NotExistsItemException("The document " + docID + " does " + "not exist in the dataset.");
        }
    }

    public void removeItem(Integer itemID) throws NotExistsItemException {
        ItemDocElement item = this.items.remove(itemID);
        if (item != null) {
            ArrayList<Integer> docList = item.getDocumentsList();
            for (int i = 0; i < docList.size(); ++i) {
                DocItemElement doc = this.docs.get(docList.get(i));
                doc.removeItem(itemID);
            }
        } else {
            throw new NotExistsItemException("The item " + itemID + " does not " + "exist in the dataset.");
        }
    }

    public boolean addItemToDocument(Integer docID, Integer itemID, String itemLabel) throws NotExistsItemException {
        DocItemElement doc = this.docs.get(docID);
        if (doc != null) {
            ItemDocElement item = this.items.get(itemID);
            if (item == null) {
                item = new ItemDocElement(itemID, itemLabel);
                this.items.put(itemID, item);
            }
            if (!doc.containsItem(itemID)) {
                doc.addItem(itemID);
                item.addDocument(docID);
                return true;
            }
            return false;
        }
        throw new NotExistsItemException("The document " + docID + " does " + "not exist in the dataset.");
    }

    public int getDocumentCitations(Integer docID) throws NotExistsItemException {
        DocItemElement doc = this.docs.get(docID);
        if (doc != null) {
            return doc.getTimesCited();
        }
        throw new NotExistsItemException("The document " + docID + " does " + "not exist in the dataset.");
    }

    public int getDocumentsCount() {
        return this.docs.size();
    }

    public int getDocumentFrequency(Integer docID) throws NotExistsItemException {
        DocItemElement doc = this.docs.get(docID);
        if (doc != null) {
            return doc.getItemsCount();
        }
        throw new NotExistsItemException("The document " + docID + " does not " + "exist in the dataset.");
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public int getItemFrequency(Integer itemID) throws NotExistsItemException {
        ItemDocElement item = this.items.get(itemID);
        if (item != null) {
            return item.getDocumentsCount();
        }
        throw new NotExistsItemException("The item " + itemID + " does not " + "exist in the dataset.");
    }

    public String getItemLabel(Integer itemID) throws NotExistsItemException {
        ItemDocElement item = this.items.get(itemID);
        if (item != null) {
            return item.getLabel();
        }
        throw new NotExistsItemException("The item " + itemID + " does not " + "exist in the dataset.");
    }

    public int getItemsInDocumentCount(Integer docID) throws NotExistsItemException {
        DocItemElement doc = this.docs.get(docID);
        if (doc != null) {
            return doc.getItemsCount();
        }
        throw new NotExistsItemException("The document " + docID + " does " + "not exist in the dataset.");
    }

    public Dataset clone() {
        Dataset dataset = new Dataset();
        for (Integer id : this.docs.keySet()) {
            dataset.docs.put(id, this.docs.get(id).clone());
        }
        for (Integer id : this.items.keySet()) {
            dataset.items.put(id, this.items.get(id).clone());
        }
        return dataset;
    }
}

