/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.DocHighLevelItemElement;
import scimat.api.dataset.HighLevelItemDocElement;
import scimat.api.dataset.exception.NotExistsItemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedDataset
extends Dataset
implements Serializable,
Cloneable {
    private TreeMap<Integer, HighLevelItemDocElement> highLevelItemDocElement = new TreeMap();
    private TreeMap<Integer, DocHighLevelItemElement> docHighLevelItemElement = new TreeMap();

    public AggregatedDataset(Dataset dataset) {
        super(dataset);
        ArrayList<Integer> docs = dataset.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            Integer docID = docs.get(i);
            this.docHighLevelItemElement.put(docID, new DocHighLevelItemElement(docID));
        }
    }

    public boolean addHighLevelItem(Integer highLevelItemID, String label) {
        if (this.highLevelItemDocElement.containsKey(highLevelItemID)) {
            return false;
        }
        this.highLevelItemDocElement.put(highLevelItemID, new HighLevelItemDocElement(highLevelItemID, label));
        return true;
    }

    public ArrayList<Integer> getHighLevelItems() {
        return new ArrayList<Integer>(this.highLevelItemDocElement.keySet());
    }

    public int getHighLevelItemsCount() {
        return this.highLevelItemDocElement.size();
    }

    public String getHighLevelItemLabel(Integer highLevelItemID) {
        HighLevelItemDocElement aggregatedDocItem = this.highLevelItemDocElement.get(highLevelItemID);
        if (aggregatedDocItem != null) {
            return aggregatedDocItem.getLabel();
        }
        throw new NotExistsItemException("The high level item " + highLevelItemID + " does " + "not exist in the aggregated dataset.");
    }

    public boolean addDocumentToHighLevelItem(Integer highLevelItemID, Integer docID) throws NotExistsItemException {
        HighLevelItemDocElement highLevelItem = this.highLevelItemDocElement.get(highLevelItemID);
        if (highLevelItem != null) {
            DocHighLevelItemElement doc = this.docHighLevelItemElement.get(docID);
            if (doc != null) {
                if (highLevelItem.addDocument(docID)) {
                    doc.addHighLevelItem(highLevelItemID);
                    return true;
                }
                return false;
            }
            throw new NotExistsItemException("The document " + docID + " does " + "not exist in the aggregated dataset.");
        }
        throw new NotExistsItemException("The high level item " + highLevelItemID + " does " + "not exist in the aggregated dataset.");
    }

    public ArrayList<Integer> getDocumentsInHighLevelItem(Integer highLevelItemID) {
        HighLevelItemDocElement aggregatedDocItem = this.highLevelItemDocElement.get(highLevelItemID);
        if (aggregatedDocItem != null) {
            return aggregatedDocItem.getDocumentsList();
        }
        throw new NotExistsItemException("The high level item " + highLevelItemID + " does " + "not exist in the aggregated dataset.");
    }

    public int getDocumentsInHighLevelItemCount(Integer highLevelItemID) {
        HighLevelItemDocElement aggregatedDocItem = this.highLevelItemDocElement.get(highLevelItemID);
        if (aggregatedDocItem != null) {
            return aggregatedDocItem.getDocumentsCount();
        }
        throw new NotExistsItemException("The high level item " + highLevelItemID + " does " + "not exist in the aggregated dataset.");
    }

    @Override
    public void removeDocument(Integer docID) throws NotExistsItemException {
        super.removeDocument(docID);
        DocHighLevelItemElement doc = this.docHighLevelItemElement.remove(docID);
        ArrayList<Integer> highLevelItemIDs = doc.getHighLevelItemsList();
        for (int i = 0; i < highLevelItemIDs.size(); ++i) {
            this.highLevelItemDocElement.get(highLevelItemIDs.get(i)).removeDocument(docID);
        }
    }

    @Override
    public AggregatedDataset clone() {
        AggregatedDataset aggregatedDataset = new AggregatedDataset(super.clone());
        for (Integer id : this.docHighLevelItemElement.keySet()) {
            aggregatedDataset.docHighLevelItemElement.put(id, this.docHighLevelItemElement.get(id).clone());
        }
        for (Integer id : this.highLevelItemDocElement.keySet()) {
            aggregatedDataset.highLevelItemDocElement.put(id, this.highLevelItemDocElement.get(id).clone());
        }
        return aggregatedDataset;
    }
}

