/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.temporal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeSet;
import scimat.api.analysis.temporal.OverlappingMapItem;
import scimat.api.analysis.temporal.OverlappingMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlappingMap
implements Serializable {
    private ArrayList<OverlappingMapItem> overlappingMapItems = new ArrayList();
    private ArrayList<ArrayList<Integer>> sharedItems = new ArrayList();
    private ArrayList<Double> overlappingWeights = new ArrayList();

    public void addItem(ArrayList<Integer> items, OverlappingMeasure measure) {
        if (this.overlappingMapItems.isEmpty()) {
            this.overlappingMapItems.add(new OverlappingMapItem(items, null, null));
        } else {
            OverlappingMapItem lastItem = this.overlappingMapItems.get(this.overlappingMapItems.size() - 1);
            OverlappingMapItem itemToAdd = new OverlappingMapItem(items, null, null);
            this.overlappingMapItems.add(itemToAdd);
            TreeSet<Integer> shared = new TreeSet<Integer>(lastItem.getItems());
            shared.retainAll(itemToAdd.getItems());
            TreeSet<Integer> newItems = new TreeSet<Integer>(itemToAdd.getItems());
            newItems.removeAll(lastItem.getItems());
            TreeSet<Integer> dissapeared = new TreeSet<Integer>(lastItem.getItems());
            dissapeared.removeAll(itemToAdd.getItems());
            lastItem.setDissapearedItems(new ArrayList<Integer>(dissapeared));
            itemToAdd.setNewItems(new ArrayList<Integer>(newItems));
            this.sharedItems.add(new ArrayList<Integer>(shared));
            this.overlappingWeights.add(measure.calculateOverlapping(lastItem.getItems(), itemToAdd.getItems()));
        }
    }

    public int getPeriodCount() {
        return this.overlappingMapItems.size();
    }

    public int getItemsCountInPeriod(int sourcePeriod) {
        return this.overlappingMapItems.get(sourcePeriod).getItemsCount();
    }

    public int getNewItemsCountInPeriod(int sourcePeriod) {
        return this.overlappingMapItems.get(sourcePeriod).getNewItemsCount();
    }

    public int getDissapearedItemsCountInPeriod(int sourcePeriod) {
        return this.overlappingMapItems.get(sourcePeriod).getDissapearedItemsCount();
    }

    public double getOverlappingWeight(int sourcePeriod) {
        return this.overlappingWeights.get(sourcePeriod);
    }

    public int getOverlappedItemsCountInPeriod(int sourcePeriod) {
        return this.sharedItems.get(sourcePeriod).size();
    }
}

