/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.temporal;

import java.util.ArrayList;
import scimat.api.analysis.temporal.EvolutionMap;
import scimat.api.analysis.temporal.EvolutionMapNexus;
import scimat.api.analysis.temporal.OverlappingMeasure;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.mapping.clustering.result.ClusterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMapBuilder {
    private OverlappingMeasure measure;

    public EvolutionMapBuilder(OverlappingMeasure measure) {
        this.measure = measure;
    }

    public EvolutionMap buildEvolutionMap(ArrayList<ClusterSet> clusterSets) {
        int j;
        ClusterSet clusterSetTarget;
        int i;
        ClusterSet clusterSetSource;
        EvolutionMap evolutionMap = new EvolutionMap(clusterSets.size() - 1);
        if (clusterSets.size() > 1) {
            clusterSetSource = clusterSets.get(0);
            int evolutionGap = 0;
            for (i = 1; i < clusterSets.size(); ++i) {
                clusterSetTarget = clusterSets.get(i);
                for (j = 0; j < clusterSetSource.getClustersCount(); ++j) {
                    Cluster clusterSource = clusterSetSource.getCluster(j);
                    for (int k = 0; k < clusterSetTarget.getClustersCount(); ++k) {
                        Cluster clusterTarget = clusterSetTarget.getCluster(k);
                        double weight = this.measure.calculateOverlapping(clusterSource.getNodes(), clusterTarget.getNodes());
                        if (!(weight > 0.0)) continue;
                        boolean shareMainNode = clusterSource.getNodes().contains(clusterTarget.getMainNode()) || clusterTarget.getNodes().contains(clusterSource.getMainNode());
                        EvolutionMapNexus nexus = new EvolutionMapNexus(shareMainNode, weight);
                        evolutionMap.addNexus(evolutionGap, j, k, nexus);
                    }
                }
                clusterSetSource = clusterSetTarget;
                ++evolutionGap;
            }
        }
        for (i = 0; i < clusterSets.size(); ++i) {
            clusterSetSource = clusterSets.get(i);
            for (j = i + 1; j < clusterSets.size(); ++j) {
                clusterSetTarget = clusterSets.get(j);
            }
        }
        return evolutionMap;
    }
}

