/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.temporal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import scimat.api.analysis.temporal.EvolutionMapNexus;

public class EvolutionMap
implements Serializable {
    private ArrayList<TreeMap<Integer, TreeMap<Integer, EvolutionMapNexus>>> nexusList = new ArrayList();

    public EvolutionMap(int evolutionGap) {
        for (int i = 0; i < evolutionGap; ++i) {
            this.nexusList.add(new TreeMap());
        }
    }

    public void addNexus(int evolutionGap, int clusterSource, int clusterTarget, EvolutionMapNexus nexus) {
        TreeMap<Integer, EvolutionMapNexus> nexuses = this.nexusList.get(evolutionGap).get(clusterSource);
        if (nexuses == null) {
            nexuses = new TreeMap();
            this.nexusList.get(evolutionGap).put(clusterSource, nexuses);
        }
        nexuses.put(clusterTarget, nexus);
    }

    public EvolutionMapNexus getEvolutionNexus(int evolutionGap, int clusterSource, int clusterTarget) {
        TreeMap<Integer, EvolutionMapNexus> internalMap;
        EvolutionMapNexus nexus = null;
        if (this.nexusList.size() > evolutionGap && (internalMap = this.nexusList.get(evolutionGap).get(clusterSource)) != null) {
            nexus = internalMap.get(clusterTarget);
        }
        return nexus;
    }

    public int getEvolutionGapCount() {
        return this.nexusList.size();
    }
}

