/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.statistic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.math.stat.Frequency;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticBasedFrequency {
    private DescriptiveStatistics statistics;
    private Frequency frequency;

    public StatisticBasedFrequency() {
        this.init();
    }

    public StatisticBasedFrequency(ArrayList<Integer> frequencies) {
        this.init();
        this.addFrequency(frequencies);
    }

    public final void addFrequency(int frequency) {
        this.statistics.addValue((double)frequency);
        this.frequency.addValue(frequency);
    }

    public final void addFrequency(ArrayList<Integer> frequencies) {
        for (int i = 0; i < frequencies.size(); ++i) {
            this.addFrequency(frequencies.get(i));
        }
    }

    public int getMax() {
        return (int)this.statistics.getMax();
    }

    public int getMin() {
        return (int)this.statistics.getMin();
    }

    public double getMean() {
        return this.statistics.getMean();
    }

    public double getMedian() {
        return this.statistics.getPercentile(50.0);
    }

    public double getStandardDesviation() {
        return this.statistics.getStandardDeviation();
    }

    public double getVariance() {
        return this.statistics.getVariance();
    }

    public long getMaxFrequency() {
        Iterator it = this.frequency.valuesIterator();
        if (it.hasNext()) {
            return (Long)it.next();
        }
        return 0L;
    }

    public long getCumFrequency(int v) {
        return this.frequency.getCumFreq(v);
    }

    private void init() {
        this.statistics = new DescriptiveStatistics();
        this.frequency = new Frequency((Comparator)new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o2.compareTo(o1);
            }
        });
    }
}

