/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.performance.quality;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import scimat.api.analysis.performance.DocumentAggregationMeasure;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.analysis.performance.quality.HIndex;
import scimat.api.dataset.Dataset;

public class Q2Index
implements DocumentAggregationMeasure {
    private Dataset dataset;

    public Q2Index(Dataset dataset) {
        this.dataset = dataset;
    }

    public double calculateMeasure(DocumentSet documentSet) {
        int i;
        HIndex hIndexFunction = new HIndex(this.dataset);
        ArrayList<Integer> citationsList = new ArrayList<Integer>();
        ArrayList<Integer> docsList = documentSet.getDocuments();
        for (i = 0; i < docsList.size(); ++i) {
            int citations = this.dataset.getDocumentCitations(docsList.get(i));
            if (citations <= 0) continue;
            citationsList.add(citations);
        }
        Collections.sort(citationsList, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        i = 0;
        double hIndex = hIndexFunction.calculateMeasure(documentSet);
        if (citationsList.isEmpty()) {
            return 0.0;
        }
        double median = hIndex % 2.0 == 1.0 ? (double)((Integer)citationsList.get(((int)hIndex + 1) / 2 - 1)).intValue() : (double)((Integer)citationsList.get((int)hIndex / 2 - 1)).intValue();
        return Math.sqrt(hIndex * median);
    }
}

