/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.performance.quality;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import scimat.api.analysis.performance.DocumentAggregationMeasure;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.dataset.Dataset;

public class HIndex
implements DocumentAggregationMeasure {
    private Dataset dataset;

    public HIndex(Dataset dataset) {
        this.dataset = dataset;
    }

    public double calculateMeasure(DocumentSet documentSet) {
        int i;
        ArrayList<Integer> citationsList = new ArrayList<Integer>();
        ArrayList<Integer> docsList = documentSet.getDocuments();
        for (i = 0; i < docsList.size(); ++i) {
            int citations = this.dataset.getDocumentCitations(docsList.get(i));
            if (citations <= 0) continue;
            citationsList.add(citations);
        }
        Collections.sort(citationsList, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        double hIndex = 0.0;
        boolean flag = true;
        for (i = 0; i < citationsList.size() && flag; ++i) {
            if ((Integer)citationsList.get(i) >= i + 1) continue;
            flag = false;
            hIndex = i;
        }
        if (i == citationsList.size() && flag) {
            hIndex = i;
        }
        return hIndex;
    }
}

