/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.performance.quality;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import scimat.api.analysis.performance.DocumentAggregationMeasure;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.dataset.Dataset;

public class GIndex
implements DocumentAggregationMeasure {
    private Dataset dataset;

    public GIndex(Dataset dataset) {
        this.dataset = dataset;
    }

    public double calculateMeasure(DocumentSet documentSet) {
        int i;
        ArrayList<Integer> citations = new ArrayList<Integer>();
        ArrayList<Integer> docsList = documentSet.getDocuments();
        for (i = 0; i < docsList.size(); ++i) {
            int citationsCount = this.dataset.getDocumentCitations(docsList.get(i));
            if (citationsCount <= 0) continue;
            citations.add(citationsCount);
        }
        Collections.sort(citations, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        double sum = 0.0;
        boolean flag = true;
        double gIndex = 0.0;
        for (i = 0; i < citations.size() && flag; ++i) {
            if ((sum += (double)((Integer)citations.get(i)).intValue()) >= Math.pow(i + 1, 2.0)) {
                gIndex += 1.0;
                continue;
            }
            flag = false;
        }
        return gIndex;
    }
}

