/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.performance.docmapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import scimat.api.analysis.performance.docmapper.DocumentMapper;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionDocumentMapper
implements DocumentMapper {
    private Dataset dataset;

    public UnionDocumentMapper(Dataset dataset) {
        this.dataset = dataset;
    }

    public UnionDocumentMapper(AggregatedDataset aggregatedDataset) {
        this.dataset = aggregatedDataset;
    }

    @Override
    public DocumentSet executeMapper(ArrayList<Integer> itemsList) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i = 0; i < itemsList.size(); ++i) {
            result.addAll(this.getDocuments(itemsList.get(i)));
        }
        DocumentSet documentSet = new DocumentSet();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            documentSet.addDocument((Integer)iterator.next());
        }
        return documentSet;
    }

    private ArrayList<Integer> getDocuments(Integer itemID) {
        if (this.dataset instanceof AggregatedDataset) {
            return ((AggregatedDataset)this.dataset).getDocumentsInHighLevelItem(itemID);
        }
        return this.dataset.getDocumentsInItem(itemID);
    }
}

