/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.performance.docmapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import scimat.api.analysis.performance.docmapper.DocumentMapper;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KCoreDocumentMapper
implements DocumentMapper {
    private int k;
    private Dataset dataset;

    public KCoreDocumentMapper(int k, Dataset dataset) {
        this.k = k;
        this.dataset = dataset;
    }

    public KCoreDocumentMapper(int k, AggregatedDataset aggregatedDataset) {
        this.k = k;
        this.dataset = aggregatedDataset;
    }

    @Override
    public DocumentSet executeMapper(ArrayList<Integer> itemsList) {
        TreeMap<Integer, Integer> docCounter = new TreeMap<Integer, Integer>();
        for (int i = 0; i < itemsList.size(); ++i) {
            ArrayList<Integer> docList = this.getDocuments(itemsList.get(i));
            for (int j = 0; j < docList.size(); ++j) {
                Integer count = (Integer)docCounter.get(docList.get(j));
                if (count != null) {
                    docCounter.put(docList.get(j), count + 1);
                    continue;
                }
                docCounter.put(docList.get(j), 1);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator iterator = docCounter.keySet().iterator();
        while (iterator.hasNext()) {
            Integer docID = (Integer)iterator.next();
            if ((Integer)docCounter.get(docID) < this.k) continue;
            result.add(docID);
        }
        DocumentSet documentSet = new DocumentSet();
        while (iterator.hasNext()) {
            documentSet.addDocument((Integer)iterator.next());
        }
        return documentSet;
    }

    private ArrayList<Integer> getDocuments(Integer itemID) {
        if (this.dataset instanceof AggregatedDataset) {
            return ((AggregatedDataset)this.dataset).getDocumentsInHighLevelItem(itemID);
        }
        return this.dataset.getDocumentsInItem(itemID);
    }
}

