/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.performance.docmapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import scimat.api.analysis.performance.docmapper.DocumentMapper;
import scimat.api.analysis.performance.docmapper.DocumentSet;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.NetworkPair;
import scimat.api.mapping.WholeNetwork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreDocumentMapper
implements DocumentMapper {
    private WholeNetwork wholeNetwork;
    private Dataset dataset;

    public CoreDocumentMapper(WholeNetwork wholeNetwork, Dataset dataset) {
        this.wholeNetwork = wholeNetwork;
        this.dataset = dataset;
    }

    public CoreDocumentMapper(WholeNetwork wholeNetwork, AggregatedDataset aggregatedDataset) {
        this.wholeNetwork = wholeNetwork;
        this.dataset = aggregatedDataset;
    }

    @Override
    public DocumentSet executeMapper(ArrayList<Integer> itemsList) {
        TreeSet result = new TreeSet();
        TreeSet<Integer> tmpUnion = new TreeSet<Integer>();
        ArrayList<NetworkPair> pairs = this.wholeNetwork.getInternalPairs(itemsList);
        for (int i = 0; i < pairs.size(); ++i) {
            tmpUnion.clear();
            tmpUnion.addAll(this.getDocuments(pairs.get(i).getID().getElementA()));
            tmpUnion.retainAll(this.getDocuments(pairs.get(i).getID().getElementB()));
            result.addAll(tmpUnion);
        }
        DocumentSet documentSet = new DocumentSet();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            documentSet.addDocument((Integer)iterator.next());
        }
        return documentSet;
    }

    private ArrayList<Integer> getDocuments(Integer itemID) {
        if (this.dataset instanceof AggregatedDataset) {
            return ((AggregatedDataset)this.dataset).getDocumentsInHighLevelItem(itemID);
        }
        return this.dataset.getDocumentsInItem(itemID);
    }
}

