/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.network.statistics;

import java.util.ArrayList;
import scimat.api.dataset.UndirectNetworkMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxAverageSimilarNode {
    public Integer execute(UndirectNetworkMatrix matrix, ArrayList<Integer> nodes) {
        double currentSim;
        int i;
        double[] similarities = new double[nodes.size()];
        for (i = 0; i < nodes.size(); ++i) {
            Integer sourceNode = nodes.get(i);
            ArrayList<Integer> neighbours = matrix.getNeighbours(sourceNode);
            currentSim = 0.0;
            for (int j = 0; j < neighbours.size(); ++j) {
                Integer targetNode = neighbours.get(j);
                currentSim += matrix.getEdge(sourceNode, targetNode);
            }
            similarities[i] = currentSim / (double)neighbours.size();
        }
        Integer finalNode = null;
        i = 0;
        if (similarities.length > 0) {
            finalNode = nodes.get(i);
            currentSim = similarities[i];
            for (i = 1; i < similarities.length; ++i) {
                if (!(currentSim > similarities[i])) continue;
                finalNode = nodes.get(i);
            }
        }
        return finalNode;
    }
}

