/*
 * Decompiled with CFR 0.152.
 */
package scimat.api.analysis.network.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import scimat.api.analysis.network.statistics.ClusterDeriveMeasure;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.utils.property.DoubleProperty;
import scimat.api.utils.property.Property;
import scimat.api.utils.property.PropertyTypes;

public class CalculateNormalizedRange
implements ClusterDeriveMeasure {
    public boolean calculateMeasures(ClusterSet clusterSet, final String propertyKey, String newProperty) {
        int i;
        ArrayList<Cluster> clusterList = clusterSet.getClusters();
        boolean flag = true;
        for (i = 0; i < clusterList.size(); ++i) {
            Property property = clusterList.get(i).getProperties().getProperty(propertyKey);
            if (property != null && property.getType().equals((Object)PropertyTypes.Double)) continue;
            flag = false;
        }
        if (flag) {
            Collections.sort(clusterList, new Comparator<Cluster>(){

                @Override
                public int compare(Cluster o1, Cluster o2) {
                    return Double.compare((Double)((DoubleProperty)o1.getProperties().getProperty(propertyKey)).getValue(), (Double)((DoubleProperty)o2.getProperties().getProperty(propertyKey)).getValue());
                }
            });
            for (i = 0; i < clusterList.size(); ++i) {
                clusterList.get(i).getProperties().addProperty(newProperty, new DoubleProperty((1.0 + (double)i) / (double)clusterList.size()));
            }
            flag = true;
        }
        return flag;
    }
}

