/*
 * Decompiled with CFR 0.152.
 */
package scimat.analysis;

import java.util.ArrayList;
import scimat.analysis.AnalysisConfiguration;
import scimat.analysis.AnalysisPeriodResult;
import scimat.analysis.GlobalAnalysisResult;
import scimat.analysis.KindOfMatrixEnum;
import scimat.analysis.LongitudinalResult;
import scimat.api.analysis.network.labeller.AggregatedCouplingBasicClusterLabellerBasedOnMainNode;
import scimat.api.analysis.network.labeller.AggregatedCouplingNodeLabeller;
import scimat.api.analysis.network.labeller.BasicClusterLabellerBasedOnMainNode;
import scimat.api.analysis.network.labeller.BasicNodeLabeller;
import scimat.api.analysis.network.labeller.ClusterLabeller;
import scimat.api.analysis.network.labeller.ClusterSetLabelSetter;
import scimat.api.analysis.network.labeller.CouplingClusterLabellerBasedOnMainNode;
import scimat.api.analysis.network.labeller.CouplingNodeLabeller;
import scimat.api.analysis.network.labeller.NodeLabelSetter;
import scimat.api.analysis.network.labeller.NodeLabeller;
import scimat.api.analysis.network.statistics.CalculateNormalizedRange;
import scimat.api.analysis.network.statistics.CallonCentrality;
import scimat.api.analysis.network.statistics.CallonDensity;
import scimat.api.analysis.network.statistics.ClusterSetNetworkMeasureSetter;
import scimat.api.analysis.performance.ClusterSetAggregationDocumentsMeasureSetter;
import scimat.api.analysis.performance.DocumentAggregationMeasure;
import scimat.api.analysis.performance.WholeNetworkAggregationDocumentsMeasureSetter;
import scimat.api.analysis.performance.docmapper.AggregatedCouplingNodeDocumentMapper;
import scimat.api.analysis.performance.docmapper.BasicNodeDocumentMapper;
import scimat.api.analysis.performance.docmapper.ClusterSetDocumentsSetter;
import scimat.api.analysis.performance.docmapper.CoreDocumentMapper;
import scimat.api.analysis.performance.docmapper.CouplingDocumentMapper;
import scimat.api.analysis.performance.docmapper.CouplingNodeDocumentMapper;
import scimat.api.analysis.performance.docmapper.DocumentMapper;
import scimat.api.analysis.performance.docmapper.IntersectionDocumentMapper;
import scimat.api.analysis.performance.docmapper.KCoreDocumentMapper;
import scimat.api.analysis.performance.docmapper.NodeDocumentMapper;
import scimat.api.analysis.performance.docmapper.SecondaryDocumentMapper;
import scimat.api.analysis.performance.docmapper.UnionDocumentMapper;
import scimat.api.analysis.performance.docmapper.WholeNetworkDocumentsSetter;
import scimat.api.analysis.performance.quality.AverageCitationAggregationMeasure;
import scimat.api.analysis.performance.quality.GIndex;
import scimat.api.analysis.performance.quality.HGIndex;
import scimat.api.analysis.performance.quality.HIndex;
import scimat.api.analysis.performance.quality.MaxCitationAggregationMeasure;
import scimat.api.analysis.performance.quality.MinCitationAggregationMeasure;
import scimat.api.analysis.performance.quality.Q2Index;
import scimat.api.analysis.performance.quality.SumCitationAggregationMeasure;
import scimat.api.analysis.performance.quantity.DocumentCountAggregationMeasure;
import scimat.api.analysis.temporal.EvolutionMap;
import scimat.api.analysis.temporal.EvolutionMapBuilder;
import scimat.api.analysis.temporal.OverlappingMap;
import scimat.api.analysis.temporal.OverlappingMapBuilder;
import scimat.api.analysis.temporal.OverlappingMeasure;
import scimat.api.dataset.AggregatedDataset;
import scimat.api.dataset.Dataset;
import scimat.api.dataset.UndirectNetworkMatrix;
import scimat.api.dataset.datasetbuilder.AggregatedDatasetBuilder;
import scimat.api.dataset.datasetbuilder.AggregatedDatasetByAuthorBuilder;
import scimat.api.dataset.datasetbuilder.AggregatedDatasetByJournalBuilder;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnAuthorReferencesBuilder;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnAuthorsBuilder;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnReferencesBuilder;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnReferencesSourcesBuilder;
import scimat.api.dataset.datasetbuilder.DatasetBasedOnWordsBuilder;
import scimat.api.dataset.datasetbuilder.DatasetBuilder;
import scimat.api.dataset.networkbuilder.NetworkAggregatedCouplingBuilder;
import scimat.api.dataset.networkbuilder.NetworkBuilder;
import scimat.api.dataset.networkbuilder.NetworkCoOccurrenceBuilder;
import scimat.api.dataset.networkbuilder.NetworkCouplingBuilder;
import scimat.api.mapping.Node;
import scimat.api.mapping.WholeNetwork;
import scimat.api.mapping.clustering.AverageLinkClustering;
import scimat.api.mapping.clustering.CentersSimpleGroupingAlgorithm;
import scimat.api.mapping.clustering.ClusteringAlgorithm;
import scimat.api.mapping.clustering.CompleteLinkClustering;
import scimat.api.mapping.clustering.SingleLinkClustering;
import scimat.api.mapping.clustering.SumLinkClustering;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.preprocessing.reduction.data.FilterItemByFrequency;
import scimat.api.preprocessing.reduction.network.FilterByEdgeValue;
import scimat.api.similaritymeasure.CoOccurrenceNormalizer;
import scimat.api.similaritymeasure.CouplingNormalizer;
import scimat.api.similaritymeasure.Normalizer;
import scimat.api.similaritymeasure.direct.AssociationStrengthMeasure;
import scimat.api.similaritymeasure.direct.DirectSimilarityMeasure;
import scimat.api.similaritymeasure.direct.EquivalenceIndexMeasure;
import scimat.api.similaritymeasure.direct.InclusionIndexMeasure;
import scimat.api.similaritymeasure.direct.JaccardIndexMeasure;
import scimat.api.similaritymeasure.direct.SaltonCosineMeasure;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.observabletask.ObservableTask;
import scimat.observabletask.TaskStatus;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoAnalysisWorker
extends ObservableTask<GlobalAnalysisResult, Void> {
    private KnowledgeBaseManager kbm;
    private AnalysisConfiguration analysisConfiguration;
    private int globalStep;
    private int maxGlobalStep;
    private int subStep;
    private int maxSubStep;

    public DoAnalysisWorker(KnowledgeBaseManager kbm, AnalysisConfiguration analysisConfiguration) {
        this.kbm = kbm;
        this.analysisConfiguration = analysisConfiguration;
        this.setDeterminateMode(true);
    }

    @Override
    protected GlobalAnalysisResult doInBackground() throws Exception {
        GlobalAnalysisResult result = new GlobalAnalysisResult(this.analysisConfiguration);
        ArrayList<ClusterSet> clusterSets = new ArrayList<ClusterSet>();
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        try {
            this.setTaskStatus(TaskStatus.STARTED);
            int periodsCount = this.analysisConfiguration.getPeriods().size();
            this.maxGlobalStep = periodsCount + 1;
            int i = 0;
            this.globalStep = 0;
            while (i < periodsCount && !this.isCancelled()) {
                AnalysisPeriodResult analysisPeriodResult = this.doPeriod(i);
                result.addAnalysisPeriodResult(analysisPeriodResult);
                clusterSets.add(analysisPeriodResult.getClusterSet());
                datasets.add(analysisPeriodResult.getOriginalDataset());
                ++i;
                ++this.globalStep;
            }
            this.subStep = 1;
            EvolutionMap evolutionMap = this.buildEvolutionMap(clusterSets);
            this.setProgress(this.calculateProgress(this.globalStep, this.maxGlobalStep, this.subStep, this.maxSubStep));
            ++this.subStep;
            OverlappingMap overlappingMap = this.buildOverlappingMap(datasets);
            this.setProgress(this.calculateProgress(this.globalStep, this.maxGlobalStep, this.subStep, this.maxSubStep));
            result.setLongitudinalResult(new LongitudinalResult(evolutionMap, overlappingMap));
            ++this.globalStep;
        }
        catch (Exception e) {
            this.setException(e);
            throw e;
        }
        this.setProgress(100);
        return result;
    }

    private AnalysisPeriodResult doPeriod(int period) throws Exception {
        Dataset originalDataset = null;
        Dataset dataset = null;
        UndirectNetworkMatrix network = null;
        ClusterSet clusterSet = null;
        this.maxSubStep = 14;
        this.subStep = 1;
        System.out.println("Period " + period);
        while (this.subStep <= this.maxSubStep && !this.isCancelled()) {
            switch (this.subStep) {
                case 1: {
                    System.out.println("  Building the dataset...");
                    originalDataset = this.buildDataSet(period);
                    dataset = originalDataset.clone();
                    break;
                }
                case 2: {
                    System.out.println("  Building the aggregated dataset...");
                    dataset = this.buildAggregatedDataset(dataset);
                    break;
                }
                case 3: {
                    System.out.println("  Data reduction...");
                    this.dataReduction(period, dataset);
                    break;
                }
                case 4: {
                    System.out.println("  Building the network...");
                    network = this.buildNetwork(dataset);
                    break;
                }
                case 5: {
                    System.out.println("  Network reduction...");
                    this.networkReduction(period, network);
                    break;
                }
                case 6: {
                    System.out.println("  Normalizing...");
                    this.normalization(dataset, network);
                    break;
                }
                case 7: {
                    System.out.println("  Clustering...");
                    clusterSet = this.clustering(network);
                    break;
                }
                case 8: {
                    System.out.println("  Calculating networks measures...");
                    this.setNetworkMeasures(clusterSet);
                    break;
                }
                case 9: {
                    System.out.println("  Cluster labelling...");
                    this.setClusterLabels(dataset, clusterSet);
                    break;
                }
                case 10: {
                    System.out.println("  Node labelling...");
                    this.setNodeLabels(dataset, clusterSet.getWholeNetwork().getNodes());
                    break;
                }
                case 11: {
                    System.out.println("  Cluster document mapping...");
                    this.clusterDocumentMapper(clusterSet, clusterSet.getWholeNetwork(), dataset);
                    break;
                }
                case 12: {
                    System.out.println("  Node document mapping...");
                    this.nodeDocumentMapper(dataset, clusterSet.getWholeNetwork());
                    break;
                }
                case 13: {
                    System.out.println("  Cluster quality measures...");
                    this.setQualityMeasures(dataset, clusterSet);
                    break;
                }
                case 14: {
                    System.out.println("  Node frequency...");
                    this.setNodeFrequency(dataset, clusterSet.getWholeNetwork());
                }
            }
            this.setProgress(this.calculateProgress(this.globalStep, this.maxGlobalStep, this.subStep, this.maxSubStep));
            ++this.subStep;
        }
        if (this.isCancelled()) {
            return null;
        }
        return new AnalysisPeriodResult(originalDataset, dataset, network, clusterSet);
    }

    private Dataset buildDataSet(int period) throws KnowledgeBaseException {
        DatasetBuilder datasetBuilder = null;
        ArrayList<PublishDate> publishDates = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPublishDates(this.analysisConfiguration.getPeriods().get(period).getPeriodID());
        switch (this.analysisConfiguration.getUnitOfAnalysis()) {
            case Authors: {
                datasetBuilder = new DatasetBasedOnAuthorsBuilder(this.kbm);
                break;
            }
            case AuthorsReference: {
                datasetBuilder = new DatasetBasedOnAuthorReferencesBuilder(this.kbm);
                break;
            }
            case References: {
                datasetBuilder = new DatasetBasedOnReferencesBuilder(this.kbm);
                break;
            }
            case ReferenceSources: {
                datasetBuilder = new DatasetBasedOnReferencesSourcesBuilder(this.kbm);
                break;
            }
            case Words: {
                datasetBuilder = new DatasetBasedOnWordsBuilder(this.kbm, this.analysisConfiguration.isAuthorWords(), this.analysisConfiguration.isSourceWords(), this.analysisConfiguration.isExtractedWords());
            }
        }
        return datasetBuilder.execute(publishDates);
    }

    private Dataset buildAggregatedDataset(Dataset dataset) throws KnowledgeBaseException {
        AggregatedDatasetBuilder builder = null;
        switch (this.analysisConfiguration.getKindOfMatrix()) {
            case AggregatedCouplingBasedOnAuthor: {
                builder = new AggregatedDatasetByAuthorBuilder(this.kbm);
                break;
            }
            case AggregatedCouplingBasedOnJournal: {
                builder = new AggregatedDatasetByJournalBuilder(this.kbm);
            }
        }
        if (builder == null) {
            return dataset;
        }
        return builder.execute(dataset);
    }

    private void dataReduction(int period, Dataset dataset) {
        if (this.analysisConfiguration.isFrequencyDataReduction(period)) {
            System.out.println("  Min frequency: " + this.analysisConfiguration.getMinFrequency(period));
            FilterItemByFrequency frequencyFilter = new FilterItemByFrequency(this.analysisConfiguration.getMinFrequency(period));
            frequencyFilter.execute(dataset);
        }
    }

    private UndirectNetworkMatrix buildNetwork(Dataset dataset) {
        NetworkBuilder networkBuilder = null;
        switch (this.analysisConfiguration.getKindOfMatrix()) {
            case CoOccurrence: {
                networkBuilder = new NetworkCoOccurrenceBuilder(dataset);
                break;
            }
            case BasicCoupling: {
                networkBuilder = new NetworkCouplingBuilder(dataset);
                break;
            }
            case AggregatedCouplingBasedOnAuthor: {
                networkBuilder = new NetworkAggregatedCouplingBuilder((AggregatedDataset)dataset);
                break;
            }
            case AggregatedCouplingBasedOnJournal: {
                networkBuilder = new NetworkAggregatedCouplingBuilder((AggregatedDataset)dataset);
            }
        }
        return networkBuilder.execute();
    }

    private void networkReduction(int period, UndirectNetworkMatrix network) {
        if (this.analysisConfiguration.isFrequencyDataReduction(period)) {
            System.out.println("  Min edge value: " + this.analysisConfiguration.getMinCoOccurrence(period));
            FilterByEdgeValue coOccurrenceFilter = new FilterByEdgeValue(this.analysisConfiguration.getMinCoOccurrence(period));
            coOccurrenceFilter.execute(network);
        }
    }

    private void normalization(Dataset dataset, UndirectNetworkMatrix network) {
        Normalizer normalizer = null;
        DirectSimilarityMeasure measure = null;
        switch (this.analysisConfiguration.getNormalizationMeasure()) {
            case AssociationStrength: {
                measure = new AssociationStrengthMeasure();
                break;
            }
            case EquivalenceIndex: {
                measure = new EquivalenceIndexMeasure();
                break;
            }
            case InclusionIndex: {
                measure = new InclusionIndexMeasure();
                break;
            }
            case JaccardIndex: {
                measure = new JaccardIndexMeasure();
                break;
            }
            case SaltonCosine: {
                measure = new SaltonCosineMeasure();
            }
        }
        normalizer = this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) ? new CoOccurrenceNormalizer(measure) : new CouplingNormalizer(measure);
        normalizer.execute(dataset, network);
    }

    private ClusterSet clustering(UndirectNetworkMatrix network) {
        ClusteringAlgorithm clusterAlgorithm = null;
        switch (this.analysisConfiguration.getClusteringAlgorithm()) {
            case CentersSimples: {
                clusterAlgorithm = new CentersSimpleGroupingAlgorithm(this.analysisConfiguration.getMinNetworkSize(), this.analysisConfiguration.getMaxNetworkSize());
                break;
            }
            case AverageLink: {
                clusterAlgorithm = new AverageLinkClustering(this.analysisConfiguration.getMinNetworkSize(), this.analysisConfiguration.getMaxNetworkSize(), this.analysisConfiguration.getCutOff());
                break;
            }
            case CompleteLink: {
                clusterAlgorithm = new CompleteLinkClustering(this.analysisConfiguration.getMinNetworkSize(), this.analysisConfiguration.getMaxNetworkSize(), this.analysisConfiguration.getCutOff());
                break;
            }
            case SingleLink: {
                clusterAlgorithm = new SingleLinkClustering(this.analysisConfiguration.getMinNetworkSize(), this.analysisConfiguration.getMaxNetworkSize(), this.analysisConfiguration.getCutOff());
                break;
            }
            case SumLink: {
                clusterAlgorithm = new SumLinkClustering(this.analysisConfiguration.getMinNetworkSize(), this.analysisConfiguration.getMaxNetworkSize(), this.analysisConfiguration.getCutOff());
            }
        }
        return clusterAlgorithm.execute(network);
    }

    private void setNetworkMeasures(ClusterSet clusterSet) {
        ClusterSetNetworkMeasureSetter clusterSetNetworkMeasureSetter = new ClusterSetNetworkMeasureSetter(new CallonCentrality());
        clusterSetNetworkMeasureSetter.execute(clusterSet, "callonCentrality");
        clusterSetNetworkMeasureSetter = new ClusterSetNetworkMeasureSetter(new CallonDensity());
        clusterSetNetworkMeasureSetter.execute(clusterSet, "callonDensity");
        CalculateNormalizedRange calculateNormalizedRange = new CalculateNormalizedRange();
        calculateNormalizedRange.calculateMeasures(clusterSet, "callonCentrality", "callonCentralityRange");
        calculateNormalizedRange.calculateMeasures(clusterSet, "callonDensity", "callonDensityRange");
    }

    private void setClusterLabels(Dataset dataset, ClusterSet clusterSet) {
        ClusterLabeller clusterLabeller = this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) ? new BasicClusterLabellerBasedOnMainNode(dataset) : (this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.BasicCoupling) ? new CouplingClusterLabellerBasedOnMainNode(dataset) : new AggregatedCouplingBasicClusterLabellerBasedOnMainNode((AggregatedDataset)dataset));
        ClusterSetLabelSetter setter = new ClusterSetLabelSetter(clusterLabeller);
        setter.execute(clusterSet, "clusterName");
    }

    private void setNodeLabels(Dataset dataset, ArrayList<Node> nodes) {
        NodeLabeller nodeLabeller = this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) ? new BasicNodeLabeller(dataset) : (this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.BasicCoupling) ? new CouplingNodeLabeller(dataset) : new AggregatedCouplingNodeLabeller((AggregatedDataset)dataset));
        NodeLabelSetter setter = new NodeLabelSetter(nodeLabeller);
        setter.execute(nodes, "nodeName");
    }

    private void clusterDocumentMapper(ClusterSet clusterSet, WholeNetwork wholeNetwork, Dataset dataset) {
        DocumentMapper mapper = null;
        if (this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) || this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnAuthor) || this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnJournal)) {
            ClusterSetDocumentsSetter setter;
            if (this.analysisConfiguration.isCoreMapper() && !this.isCancelled()) {
                mapper = new CoreDocumentMapper(wholeNetwork, dataset);
                setter = new ClusterSetDocumentsSetter(mapper);
                setter.execute(clusterSet, "coreDocuments");
            }
            if (this.analysisConfiguration.isSecondaryMapper() && !this.isCancelled()) {
                mapper = new SecondaryDocumentMapper(dataset);
                setter = new ClusterSetDocumentsSetter(mapper);
                setter.execute(clusterSet, "secondaryDocuments");
            }
            if (this.analysisConfiguration.iskCoreMapper() && !this.isCancelled()) {
                mapper = new KCoreDocumentMapper(this.analysisConfiguration.getkCore(), dataset);
                setter = new ClusterSetDocumentsSetter(mapper);
                setter.execute(clusterSet, "kCoreDocuments");
            }
            if (this.analysisConfiguration.isIntersectionMapper() && !this.isCancelled()) {
                mapper = new IntersectionDocumentMapper(dataset);
                setter = new ClusterSetDocumentsSetter(mapper);
                setter.execute(clusterSet, "intersectionDocument");
            }
            if (this.analysisConfiguration.isUnionMapper() && !this.isCancelled()) {
                mapper = new UnionDocumentMapper(dataset);
                setter = new ClusterSetDocumentsSetter(mapper);
                setter.execute(clusterSet, "unionDocuments");
            }
        } else if (this.analysisConfiguration.isBasicCouplingMapper() && !this.isCancelled()) {
            mapper = new CouplingDocumentMapper();
            ClusterSetDocumentsSetter setter = new ClusterSetDocumentsSetter(mapper);
            setter.execute(clusterSet, "couplingDocuments");
        }
    }

    private void nodeDocumentMapper(Dataset dataset, WholeNetwork network) {
        NodeDocumentMapper mapper = null;
        if (this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence)) {
            mapper = new BasicNodeDocumentMapper(dataset);
        } else if ((this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnAuthor) || this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnJournal)) && !this.isCancelled()) {
            mapper = new AggregatedCouplingNodeDocumentMapper((AggregatedDataset)dataset);
        } else if (this.analysisConfiguration.isBasicCouplingMapper() && !this.isCancelled()) {
            mapper = new CouplingNodeDocumentMapper();
        }
        WholeNetworkDocumentsSetter setter = new WholeNetworkDocumentsSetter(mapper);
        setter.execute(network, "nodeDocuments");
    }

    private void setQualityMeasures(Dataset dataset, ClusterSet clusterSet) {
        if (this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) || this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnAuthor) || this.analysisConfiguration.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnJournal)) {
            if (this.analysisConfiguration.isCoreMapper() && !this.isCancelled()) {
                this.setGroupQualityMasures(dataset, clusterSet, "coreDocuments");
            }
            if (this.analysisConfiguration.isSecondaryMapper() && !this.isCancelled()) {
                this.setGroupQualityMasures(dataset, clusterSet, "secondaryDocuments");
            }
            if (this.analysisConfiguration.iskCoreMapper() && !this.isCancelled()) {
                this.setGroupQualityMasures(dataset, clusterSet, "kCoreDocuments");
            }
            if (this.analysisConfiguration.isIntersectionMapper() && !this.isCancelled()) {
                this.setGroupQualityMasures(dataset, clusterSet, "intersectionDocument");
            }
            if (this.analysisConfiguration.isUnionMapper() && !this.isCancelled()) {
                this.setGroupQualityMasures(dataset, clusterSet, "unionDocuments");
            }
        } else if (this.analysisConfiguration.isBasicCouplingMapper() && !this.isCancelled()) {
            this.setGroupQualityMasures(dataset, clusterSet, "couplingDocuments");
        }
    }

    private void setGroupQualityMasures(Dataset dataset, ClusterSet clusterSet, String propertyKey) {
        DocumentAggregationMeasure measure = null;
        measure = new DocumentCountAggregationMeasure();
        ClusterSetAggregationDocumentsMeasureSetter setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
        setter.execute(clusterSet, propertyKey, propertyKey + "documentsCount");
        if (this.analysisConfiguration.isHIndex() && !this.isCancelled()) {
            measure = new HIndex(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "hIndex");
        }
        if (this.analysisConfiguration.isGIndex() && !this.isCancelled()) {
            measure = new GIndex(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "gIndex");
        }
        if (this.analysisConfiguration.isHgIndex() && !this.isCancelled()) {
            measure = new HGIndex(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "hgIndex");
        }
        if (this.analysisConfiguration.isQ2Index() && !this.isCancelled()) {
            measure = new Q2Index(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "q2Index");
        }
        if (this.analysisConfiguration.isAverageCitations() && !this.isCancelled()) {
            measure = new AverageCitationAggregationMeasure(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "averageCitations");
        }
        if (this.analysisConfiguration.isSumCitations() && !this.isCancelled()) {
            measure = new SumCitationAggregationMeasure(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "sumCitations");
        }
        if (this.analysisConfiguration.isMaxCitations() && !this.isCancelled()) {
            measure = new MaxCitationAggregationMeasure(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "maxCitations");
        }
        if (this.analysisConfiguration.isMinCitations() && !this.isCancelled()) {
            measure = new MinCitationAggregationMeasure(dataset);
            setter = new ClusterSetAggregationDocumentsMeasureSetter(measure);
            setter.execute(clusterSet, propertyKey, propertyKey + "minCitations");
        }
    }

    private void setNodeFrequency(Dataset dataset, WholeNetwork wholeNetwork) {
        DocumentCountAggregationMeasure measure = new DocumentCountAggregationMeasure();
        WholeNetworkAggregationDocumentsMeasureSetter setter = new WholeNetworkAggregationDocumentsMeasureSetter(measure);
        setter.execute(dataset, wholeNetwork, "nodeDocuments", "nodeFrequency");
    }

    private EvolutionMap buildEvolutionMap(ArrayList<ClusterSet> clusterSets) {
        DirectSimilarityMeasure measure = null;
        switch (this.analysisConfiguration.getEvolutionMapMeasure()) {
            case AssociationStrength: {
                measure = new AssociationStrengthMeasure();
                break;
            }
            case EquivalenceIndex: {
                measure = new EquivalenceIndexMeasure();
                break;
            }
            case InclusionIndex: {
                measure = new InclusionIndexMeasure();
                break;
            }
            case JaccardIndex: {
                measure = new JaccardIndexMeasure();
                break;
            }
            case SaltonCosine: {
                measure = new SaltonCosineMeasure();
            }
        }
        EvolutionMapBuilder builder = new EvolutionMapBuilder(new OverlappingMeasure(measure));
        return builder.buildEvolutionMap(clusterSets);
    }

    private OverlappingMap buildOverlappingMap(ArrayList<Dataset> datasets) {
        DirectSimilarityMeasure measure = null;
        switch (this.analysisConfiguration.getOverlappingMapMeasure()) {
            case AssociationStrength: {
                measure = new AssociationStrengthMeasure();
                break;
            }
            case EquivalenceIndex: {
                measure = new EquivalenceIndexMeasure();
                break;
            }
            case InclusionIndex: {
                measure = new InclusionIndexMeasure();
                break;
            }
            case JaccardIndex: {
                measure = new JaccardIndexMeasure();
                break;
            }
            case SaltonCosine: {
                measure = new SaltonCosineMeasure();
            }
        }
        OverlappingMapBuilder builder = new OverlappingMapBuilder(new OverlappingMeasure(measure));
        return builder.buildOverlappingMap(datasets);
    }

    private int calculateProgress(int step, int maxStep, int subStep, int maxSubstep) {
        return (int)(100.0 * ((double)subStep / (double)maxSubstep / (double)maxStep) + (double)step / (double)maxStep * 100.0);
    }
}

