/*
 * Decompiled with CFR 0.152.
 */
package scimat.analysis;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scimat.analysis.GlobalAnalysisResult;

public class CurrentAnalysis {
    private GlobalAnalysisResult results = null;

    private CurrentAnalysis() {
    }

    public static CurrentAnalysis getInstance() {
        return CurrentAnalysisHolder.INSTANCE;
    }

    public GlobalAnalysisResult getResults() {
        return this.results;
    }

    public void setResults(GlobalAnalysisResult results) {
        this.results = results;
    }

    public void loadResults(String path) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
        this.results = (GlobalAnalysisResult)ois.readObject();
        ois.close();
    }

    public void saveResults(String path) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
        oos.writeObject(this.results);
        oos.close();
    }

    private static class CurrentAnalysisHolder {
        private static final CurrentAnalysis INSTANCE = new CurrentAnalysis();

        private CurrentAnalysisHolder() {
        }
    }
}

