/*
 * Decompiled with CFR 0.152.
 */
package scimat.analysis;

import java.util.ArrayList;
import scimat.analysis.AnalysisConfiguration;
import scimat.analysis.CurrentAnalysis;
import scimat.analysis.KindOfMatrixEnum;
import scimat.analysis.PerformanceMeasuresAvailable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDocumentMappersAvailable {
    public ArrayList<String> build() {
        ArrayList<String> properties = new ArrayList<String>();
        AnalysisConfiguration conf = CurrentAnalysis.getInstance().getResults().getAnalysisConfiguration();
        if (conf.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) || conf.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnAuthor) || conf.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnJournal)) {
            if (conf.isCoreMapper()) {
                properties.add("coreDocuments");
            }
            if (conf.isSecondaryMapper()) {
                properties.add("secondaryDocuments");
            }
            if (conf.iskCoreMapper()) {
                properties.add("kCoreDocuments");
            }
            if (conf.isIntersectionMapper()) {
                properties.add("intersectionDocument");
            }
            if (conf.isUnionMapper()) {
                properties.add("unionDocuments");
            }
        } else if (conf.isBasicCouplingMapper()) {
            properties.add("couplingDocuments");
        }
        return properties;
    }

    private void addDocumentMapperProperties(AnalysisConfiguration conf, ArrayList<PerformanceMeasuresAvailable> properties, String mapper) {
        properties.add(new PerformanceMeasuresAvailable(mapper, "documentsCount"));
        if (conf.isHIndex()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "hIndex"));
        }
        if (conf.isGIndex()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "gIndex"));
        }
        if (conf.isHgIndex()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "hgIndex"));
        }
        if (conf.isQ2Index()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "q2Index"));
        }
        if (conf.isAverageCitations()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "averageCitations"));
        }
        if (conf.isSumCitations()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "sumCitations"));
        }
        if (conf.isMaxCitations()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "maxCitations"));
        }
        if (conf.isMinCitations()) {
            properties.add(new PerformanceMeasuresAvailable(mapper, "minCitations"));
        }
    }
}

